/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.common;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlInputFormat
extends TextInputFormat {
    public static final String START_TAG_KEY = "xmlinput.start";
    public static final String END_TAG_KEY = "xmlinput.end";

    public RecordReader<LongWritable, Text> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
        System.out.println("PROVA start " + jobConf.get(START_TAG_KEY));
        System.out.println("PROVA end " + jobConf.get(START_TAG_KEY));
        return new XmlRecordReader((FileSplit)inputSplit, jobConf);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XmlRecordReader
    implements RecordReader<LongWritable, Text> {
        private final byte[] startTag;
        private final byte[] endTag;
        private final long start;
        private final long end;
        private final FSDataInputStream fsin;
        private final DataOutputBuffer buffer = new DataOutputBuffer();

        public XmlRecordReader(FileSplit split, JobConf jobConf) throws IOException {
            this.startTag = jobConf.get(XmlInputFormat.START_TAG_KEY).getBytes("utf-8");
            this.endTag = jobConf.get(XmlInputFormat.END_TAG_KEY).getBytes("utf-8");
            this.start = split.getStart();
            System.out.println("start " + this.start);
            this.end = this.start + split.getLength();
            System.out.println("end " + this.end);
            Path file = split.getPath();
            System.out.println("file " + file.getName());
            FileSystem fs = file.getFileSystem((Configuration)jobConf);
            this.fsin = fs.open(split.getPath());
            this.fsin.seek(this.start);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean next(LongWritable key, Text value) throws IOException {
            System.out.println("next");
            if (this.fsin.getPos() < this.end && this.readUntilMatch(this.startTag, false)) {
                try {
                    this.buffer.write(this.startTag);
                    if (this.readUntilMatch(this.endTag, true)) {
                        key.set(this.fsin.getPos());
                        value.set(this.buffer.getData(), 0, this.buffer.getLength());
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    this.buffer.reset();
                }
            }
            return false;
        }

        public LongWritable createKey() {
            return new LongWritable();
        }

        public Text createValue() {
            return new Text();
        }

        public long getPos() throws IOException {
            return this.fsin.getPos();
        }

        public void close() throws IOException {
            this.fsin.close();
        }

        public float getProgress() throws IOException {
            return (float)(this.fsin.getPos() - this.start) / (float)(this.end - this.start);
        }

        private boolean readUntilMatch(byte[] match, boolean withinBlock) throws IOException {
            int i = 0;
            do {
                int b;
                if ((b = this.fsin.read()) == -1) {
                    return false;
                }
                if (withinBlock) {
                    this.buffer.write(b);
                }
                if (b == match[i]) {
                    if (++i < match.length) continue;
                    return true;
                }
                i = 0;
            } while (withinBlock || i != 0 || this.fsin.getPos() < this.end);
            return false;
        }
    }
}

