/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.security.EncryptionUtil;
import org.jets3t.service.utils.ServiceUtils;

public class AWSCredentials
implements Serializable {
    private static final long serialVersionUID = -9198887548912640773L;
    private static final Log log = LogFactory.getLog((Class)AWSCredentials.class);
    protected static final String KEYS_DELIMITER = "AWSKEYS";
    protected static final String VERSION_PREFIX = "jets3t AWS Credentials, version: ";
    private String awsAccessKey = null;
    private String awsSecretAccessKey = null;
    private String friendlyName = null;

    public AWSCredentials(String awsAccessKey, String awsSecretAccessKey) {
        this.awsAccessKey = awsAccessKey;
        this.awsSecretAccessKey = awsSecretAccessKey;
    }

    public AWSCredentials(String awsAccessKey, String awsSecretAccessKey, String friendlyName) {
        this(awsAccessKey, awsSecretAccessKey);
        this.friendlyName = friendlyName;
    }

    public String getAccessKey() {
        return this.awsAccessKey;
    }

    public String getSecretKey() {
        return this.awsSecretAccessKey;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void save(String password, File file) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        FileOutputStream fos = new FileOutputStream(file);
        this.save(password, fos);
        fos.close();
    }

    public void save(String password, OutputStream outputStream) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, IOException {
        BufferedOutputStream bufferedOS = null;
        EncryptionUtil encryptionUtil = new EncryptionUtil(password);
        bufferedOS = new BufferedOutputStream(outputStream);
        String dataToEncrypt = this.getAccessKey() + KEYS_DELIMITER + this.getSecretKey();
        byte[] encryptedData = encryptionUtil.encrypt(dataToEncrypt);
        bufferedOS.write("jets3t AWS Credentials, version: 2\n".getBytes("UTF-8"));
        bufferedOS.write((encryptionUtil.getAlgorithm() + "\n").getBytes("UTF-8"));
        bufferedOS.write(((this.friendlyName == null ? "" : this.friendlyName) + "\n").getBytes("UTF-8"));
        bufferedOS.write(encryptedData);
        bufferedOS.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AWSCredentials load(String password, File file) throws S3ServiceException {
        AWSCredentials aWSCredentials;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading credentials from file: " + file.getAbsolutePath()));
        }
        BufferedInputStream fileIS = null;
        try {
            try {
                fileIS = new BufferedInputStream(new FileInputStream(file));
                aWSCredentials = AWSCredentials.load(password, fileIS);
                Object var5_5 = null;
                if (fileIS == null) return aWSCredentials;
            }
            catch (Throwable t) {
                throw new S3ServiceException("Failed to load AWS credentials", t);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (fileIS == null) throw throwable;
            try {
                fileIS.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return aWSCredentials;
        }
        fileIS.close();
        return aWSCredentials;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AWSCredentials load(String password, BufferedInputStream inputStream) throws S3ServiceException {
        block21: {
            block20: {
                v0 = partialReadOnly = password == null;
                if (partialReadOnly) {
                    if (AWSCredentials.log.isDebugEnabled()) {
                        AWSCredentials.log.debug((Object)"Loading partial information about AWS Credentials from input stream");
                    }
                } else if (AWSCredentials.log.isDebugEnabled()) {
                    AWSCredentials.log.debug((Object)"Loading AWS Credentials from input stream");
                }
                try {
                    try {
                        encryptionUtil = null;
                        encryptedKeys = new byte[2048];
                        encryptedDataIndex = 0;
                        version = null;
                        algorithm = null;
                        friendlyName = null;
                        version = ServiceUtils.readInputStreamLineToString(inputStream, "UTF-8");
                        if (!version.startsWith("jets3t AWS Credentials, version: ")) {
                            friendlyName = version;
                            if (!partialReadOnly) {
                                encryptionUtil = EncryptionUtil.getObsoleteEncryptionUtil(password);
                            }
                        } else {
                            algorithm = ServiceUtils.readInputStreamLineToString(inputStream, "UTF-8");
                            friendlyName = ServiceUtils.readInputStreamLineToString(inputStream, "UTF-8");
                            if (!partialReadOnly) {
                                encryptionUtil = new EncryptionUtil(password, algorithm, "2");
                            }
                        }
                        if (partialReadOnly) {
                            var9_11 = new AWSCredentials(null, null, friendlyName);
                            var14_13 = null;
                            if (inputStream == null) return var9_11;
                            break block20;
                        }
                        encryptedDataIndex = inputStream.read(encryptedKeys);
                        keys = encryptionUtil.decryptString(encryptedKeys, 0, encryptedDataIndex);
                        delimOffset = keys.indexOf("AWSKEYS");
                        if (delimOffset < 0) {
                            throw new Exception("Unable to load AWS keys. Is the password correct?");
                        }
                        var12_21 = awsCredentials = new AWSCredentials(keys.substring(0, delimOffset), keys.substring(delimOffset + "AWSKEYS".length()), friendlyName);
                        break block21;
                    }
                    catch (BadPaddingException bpe) {
                        throw new S3ServiceException("Unable to decrypt AWS credentials. Is your password correct?", bpe);
                    }
                    catch (Throwable t) {
                        throw new S3ServiceException("Failed to load AWS credentials", t);
                    }
                }
                catch (Throwable var13_22) {
                    var14_15 = null;
                    if (inputStream == null) throw var13_22;
                    try {
                        inputStream.close();
                        throw var13_22;
                    }
                    catch (IOException e) {
                        throw var13_22;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [7 : 293->300)] { 
lbl55:
            // 1 sources

            inputStream.close();
            return var9_11;
lbl57:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var9_11;
        }
        var14_14 = null;
        if (inputStream == null) return var12_21;
        try {}
        catch (IOException e) {
            // empty catch block
            return var12_21;
        }
        inputStream.close();
        return var12_21;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            AWSCredentials.printHelp();
            System.exit(1);
        }
        String userName = args[0];
        File encryptedFile = new File(args[1]);
        try {
            FileOutputStream testFOS = new FileOutputStream(encryptedFile);
            testFOS.close();
        }
        catch (IOException e) {
            System.err.println("Unable to write to file: " + encryptedFile);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Please enter your AWS Credentials");
        System.out.print("Access Key: ");
        String awsAccessKey = reader.readLine();
        System.out.print("Secret Key: ");
        String awsSecretKey = reader.readLine();
        System.out.println("Please enter a password to protect your credentials file (may be empty)");
        System.out.print("Password: ");
        String password = reader.readLine();
        AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey, userName);
        awsCredentials.save(password, encryptedFile);
        System.out.println("Successfully saved AWS Credentials to " + encryptedFile);
    }

    private static void printHelp() {
        System.out.println("AWSCredentials <User Name> <File Path>");
        System.out.println();
        System.out.println("User Name: A human-friendly name for the owner of the credentials, e.g. Horace.");
        System.out.println("File Path: Path and name for the encrypted file. Will be replaced if it already exists.");
    }
}

