/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client.geo;

import com.terradue.jcatalogue.client.geo.GeoLocation;
import java.beans.ConstructorProperties;

public final class Point
extends GeoLocation {
    private final double latitude;
    private final double longitude;

    @ConstructorProperties(value={"latitude", "longitude"})
    public Point(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String toString() {
        return "Point(latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLatitude(), other.getLatitude()) != 0) {
            return false;
        }
        return Double.compare(this.getLongitude(), other.getLongitude()) == 0;
    }

    public boolean canEqual(Object other) {
        return other instanceof Point;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        long temp1 = Double.doubleToLongBits(this.getLatitude());
        long temp2 = Double.doubleToLongBits(this.getLongitude());
        result = result * 31 + (int)(temp1 >>> 32 ^ temp1);
        result = result * 31 + (int)(temp2 >>> 32 ^ temp2);
        return result;
    }
}

