/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.Socket;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.thirdparty.guava.common.base.Preconditions;
import org.apache.hadoop.thirdparty.guava.common.collect.LinkedListMultimap;

class SocketCache {
    static final Log LOG = LogFactory.getLog(SocketCache.class);
    private final LinkedListMultimap<SocketAddress, Socket> multimap = LinkedListMultimap.create();
    private final int capacity;

    public SocketCache(int capacity) {
        this.capacity = capacity;
    }

    public synchronized Socket get(SocketAddress remote) {
        List socklist = this.multimap.get((Object)remote);
        if (socklist == null) {
            return null;
        }
        Iterator iter = socklist.iterator();
        while (iter.hasNext()) {
            Socket candidate = (Socket)iter.next();
            iter.remove();
            if (candidate.isClosed()) continue;
            return candidate;
        }
        return null;
    }

    public synchronized void put(Socket sock) {
        Preconditions.checkNotNull((Object)sock);
        SocketAddress remoteAddr = sock.getRemoteSocketAddress();
        if (remoteAddr == null) {
            LOG.warn((Object)("Cannot cache (unconnected) socket with no remote address: " + sock));
            IOUtils.closeSocket(sock);
            return;
        }
        if (this.capacity == this.multimap.size()) {
            this.evictOldest();
        }
        this.multimap.put((Object)remoteAddr, (Object)sock);
    }

    public synchronized int size() {
        return this.multimap.size();
    }

    private synchronized void evictOldest() {
        Iterator iter = this.multimap.entries().iterator();
        if (!iter.hasNext()) {
            throw new IllegalStateException("Cannot evict from empty cache!");
        }
        Map.Entry entry = (Map.Entry)iter.next();
        iter.remove();
        Socket sock = (Socket)entry.getValue();
        IOUtils.closeSocket(sock);
    }

    public synchronized void clear() {
        for (Socket sock : this.multimap.values()) {
            IOUtils.closeSocket(sock);
        }
        this.multimap.clear();
    }

    protected void finalize() {
        this.clear();
    }
}

