/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.fs.FSInputStream;

class ByteRangeInputStream
extends FSInputStream {
    protected InputStream in;
    protected URLOpener originalURL;
    protected URLOpener resolvedURL;
    protected long startPos = 0L;
    protected long currentPos = 0L;
    protected StreamStatus status = StreamStatus.SEEK;

    ByteRangeInputStream(URL url) {
        this(new URLOpener(url), new URLOpener(null));
    }

    ByteRangeInputStream(URLOpener o, URLOpener r) {
        this.originalURL = o;
        this.resolvedURL = r;
    }

    private InputStream getInputStream() throws IOException {
        if (this.status != StreamStatus.NORMAL) {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            URLOpener opener = this.resolvedURL.getURL() == null ? this.originalURL : this.resolvedURL;
            HttpURLConnection connection = opener.openConnection();
            connection.setRequestMethod("GET");
            if (this.startPos != 0L) {
                connection.setRequestProperty("Range", "bytes=" + this.startPos + "-");
            }
            connection.connect();
            this.in = connection.getInputStream();
            int respCode = connection.getResponseCode();
            if (this.startPos != 0L && respCode != 206) {
                throw new IOException("HTTP_PARTIAL expected, received " + respCode);
            }
            if (this.startPos == 0L && respCode != 200) {
                throw new IOException("HTTP_OK expected, received " + respCode);
            }
            this.resolvedURL.setURL(connection.getURL());
            this.status = StreamStatus.NORMAL;
        }
        return this.in;
    }

    @Override
    public int read() throws IOException {
        int ret = this.getInputStream().read();
        if (ret != -1) {
            ++this.currentPos;
        }
        return ret;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos != this.currentPos) {
            this.startPos = pos;
            this.currentPos = pos;
            this.status = StreamStatus.SEEK;
        }
    }

    @Override
    public long getPos() throws IOException {
        return this.currentPos;
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    static enum StreamStatus {
        NORMAL,
        SEEK;

    }

    static class URLOpener {
        protected URL url;

        public URLOpener(URL u) {
            this.url = u;
        }

        public void setURL(URL u) {
            this.url = u;
        }

        public URL getURL() {
            return this.url;
        }

        public HttpURLConnection openConnection() throws IOException {
            return (HttpURLConnection)this.url.openConnection();
        }
    }
}

