/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.processes.ird.indicator;

import com.terradue.wps_hadoop.common.input.InputUtils;
import com.terradue.wps_hadoop.common.input.ListInputResource;
import com.terradue.wps_hadoop.processes.ird.indicator.SpeciesCodes;
import com.terradue.wps_hadoop.streaming.ResultsInfo;
import com.terradue.wps_hadoop.streaming.StreamingPackagedAlgorithm;
import com.terradue.wps_hadoop.streaming.WpsHadoopConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GenericFileDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.n52.wps.server.AbstractAlgorithm;

public class IndicatorI1
extends AbstractAlgorithm {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private List<String> errors = new ArrayList<String>();

    public Map<String, IData> run(Map<String, List<IData>> inputData) {
        List<String> names = InputUtils.getListStringInputParameter(inputData, "species", true);
        List<String> speciesCodes = this.getSpeciesCodesFromSpeciesNames(names);
        String wfsUrl = InputUtils.getStringInputParameter(inputData, "wfsUrl");
        this.logger.info((Object)"Running Job TUNA ATLAS INDICATOR I1...");
        WpsHadoopConfiguration conf = new WpsHadoopConfiguration();
        StreamingPackagedAlgorithm streaming = new StreamingPackagedAlgorithm(conf);
        streaming.setAlgorithmName("indicator_i1");
        streaming.setInputResource(new ListInputResource(speciesCodes));
        streaming.addFixedParameter("wfsUrl", wfsUrl == null ? "http://mdst-macroes.ird.fr:8084/constellation/WS/wfs/tuna_atlas?" : wfsUrl);
        streaming.setDebugMode(true);
        try {
            ResultsInfo result = streaming.runSync();
            HashMap<String, IData> wpsResultMap = new HashMap<String, IData>();
            wpsResultMap.put("result", (IData)result.getXmlFileDataBinding());
            return wpsResultMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Execution job failed! " + e.getMessage());
        }
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Class<?> getInputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public Class<?> getOutputDataType(String id) {
        if (id.contentEquals("result")) {
            return GenericFileDataBinding.class;
        }
        return null;
    }

    private List<String> getSpeciesCodesFromSpeciesNames(List<String> names) {
        ArrayList<String> speciesCodes = new ArrayList<String>();
        for (String name : names) {
            speciesCodes.add(SpeciesCodes.getSpeciesCode(name));
        }
        return speciesCodes;
    }

    public static void main(String[] args) {
    }
}

