/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.processes.fao.spread;

import com.terradue.wps_hadoop.common.input.InputUtils;
import com.terradue.wps_hadoop.common.input.ListInputResource;
import com.terradue.wps_hadoop.streaming.ResultsInfo;
import com.terradue.wps_hadoop.streaming.StreamingPackagedAlgorithm;
import com.terradue.wps_hadoop.streaming.WpsHadoopConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GenericFileDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.n52.wps.server.AbstractAlgorithm;

public class Spread
extends AbstractAlgorithm {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private List<String> errors = new ArrayList<String>();

    public Map<String, IData> run(Map<String, List<IData>> inputData) {
        List<String> dataUrls = InputUtils.getListStringInputParameter(inputData, "dataUrls", true);
        String geoColumn = InputUtils.getStringInputParameter(inputData, "geoColumn", "field0");
        String quantityColumn = InputUtils.getStringInputParameter(inputData, "quantityColumn", "field4");
        String sourceAreaLayerName = InputUtils.getStringInputParameter(inputData, "sourceAreaLayerName", "FAO_AREAS");
        String targetAreaLayerName = InputUtils.getStringInputParameter(inputData, "targetAreaLayerName", "EEZ_HIGHSEAS");
        this.logger.info((Object)"Running Job SPREAD...");
        WpsHadoopConfiguration conf = new WpsHadoopConfiguration();
        StreamingPackagedAlgorithm streaming = new StreamingPackagedAlgorithm(conf);
        streaming.setAlgorithmName("spread");
        streaming.setInputResource(new ListInputResource(dataUrls));
        streaming.addFixedParameter("geoColumn", geoColumn);
        streaming.addFixedParameter("quantityColumn", quantityColumn);
        streaming.addFixedParameter("sourceAreaLayerName", sourceAreaLayerName);
        streaming.addFixedParameter("targetAreaLayerName", targetAreaLayerName);
        streaming.setDebugMode(true);
        try {
            ResultsInfo result = streaming.runSync();
            HashMap<String, IData> wpsResultMap = new HashMap<String, IData>();
            wpsResultMap.put("result", (IData)result.getXmlFileDataBinding());
            return wpsResultMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Execution job failed! " + e.getMessage());
        }
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Class<?> getInputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public Class<?> getOutputDataType(String id) {
        if (id.contentEquals("result")) {
            return GenericFileDataBinding.class;
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

