/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import thredds.catalog.DataFormatType;
import ucar.nc2.constants.FeatureType;

public interface ThreddsMetadata {
    public List<Documentation> getDocumentation();

    public List<Keyphrase> getKeyphrases();

    public List<ProjectName> getProjectNames();

    public List<Contributor> getCreator();

    public List<Contributor> getContributor();

    public List<Contributor> getPublisher();

    public List<DatePoint> getOtherDates();

    public DatePoint getCreatedDate();

    public DatePoint getModifiedDate();

    public DatePoint getIssuedDate();

    public DatePoint getValidDate();

    public DatePoint getAvailableDate();

    public DatePoint getMetadataCreatedDate();

    public DatePoint getMetadataModifiedDate();

    public GeospatialCoverage getGeospatialCoverage();

    public DateRange getTemporalCoverage();

    public List<VariableGroup> getVariableGroups();

    public long getDataSizeInBytes();

    public DataFormatType getDataFormat();

    public FeatureType getDataType();

    public String getCollectionType();

    public static interface GeospatialRange {
        public boolean isHorizontal();

        public double getStart();

        public double getSize();

        public double getResolution();

        public String getUnits();
    }

    public static interface GeospatialCoverage {
        public URI getCRS();

        public boolean isGlobal();

        public boolean isZPositiveUp();

        public List<GeospatialRange> getExtent();
    }

    public static interface Variable {
        public String getName();

        public String getDescription();

        public String getUnits();

        public String getVocabularyId();

        public String getVocabularyName();

        public String getVocabularyAuthorityId();

        public String getVocabularyAuthorityUrl();
    }

    public static interface VariableGroup {
        public String getVocabularyAuthorityId();

        public String getVocabularyAuthorityUrl();

        public List<Variable> getVariables();

        public String getVariableMapUrl();

        public boolean isEmpty();
    }

    public static interface Contributor {
        public String getName();

        public String getNamingAuthority();

        public String getRole();

        public String getEmail();

        public String getWebPage();
    }

    public static interface DateRange {
        public String getStartDateFormat();

        public String getStartDate();

        public String getEndDateFormat();

        public String getEndDate();

        public String getDuration();

        public String getResolution();
    }

    public static interface DatePoint {
        public String getDate();

        public String getDateFormat();

        public boolean isTyped();

        public String getType();
    }

    public static enum DatePointType {
        Created("created"),
        Modified("modified"),
        Valid("valid"),
        Issued("issued"),
        Available("available"),
        MetadataCreated("metadataCreated"),
        MetadataModified("metadataModified"),
        Other(""),
        Untyped("");

        private final String label;

        private DatePointType(String label) {
            this.label = label;
        }

        public static DatePointType getTypeForLabel(String label) {
            if (label == null || label.length() == 0) {
                return Untyped;
            }
            for (DatePointType dpt : DatePointType.values()) {
                if (!dpt.label.equalsIgnoreCase(label)) continue;
                return dpt;
            }
            return Other;
        }

        public String toString() {
            return this.label;
        }
    }

    public static interface ProjectName {
        public String getNamingAuthority();

        public String getName();
    }

    public static interface Keyphrase {
        public String getAuthority();

        public String getPhrase();
    }

    public static interface Documentation {
        public boolean isContainedContent();

        public String getDocType();

        public String getContent();

        public String getTitle();

        public String getExternalReference();

        public URI getExternalReferenceAsUri() throws URISyntaxException;
    }
}

