/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.MapperConfig;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.jsontype.NamedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubTypeHelper {
    public static final SubTypeHelper instance = new SubTypeHelper();

    private SubTypeHelper() {
    }

    public static List<NamedType> collectAndResolveSubtypes(Annotated base, MapperConfig<?> config, AnnotationIntrospector ai) {
        AnnotatedClass ac;
        List<NamedType> st = ai.findSubtypes(base);
        AnnotatedClass annotatedClass = ac = base instanceof AnnotatedClass ? (AnnotatedClass)base : null;
        if (st == null || st.isEmpty()) {
            String name;
            if (ac != null && (name = ai.findTypeName(ac)) != null) {
                ArrayList<NamedType> result = new ArrayList<NamedType>();
                result.add(new NamedType(ac.getRawType(), name));
                return result;
            }
            return null;
        }
        return instance._collectAndResolve(ac, config, ai, st);
    }

    protected List<NamedType> _collectAndResolve(AnnotatedClass rootType, MapperConfig<?> config, AnnotationIntrospector ai, Collection<NamedType> subtypeList) {
        NamedType rootNamedType;
        HashSet<NamedType> seen = new HashSet<NamedType>(subtypeList);
        ArrayList<NamedType> subtypes = new ArrayList<NamedType>(subtypeList);
        NamedType namedType = rootNamedType = rootType == null ? null : new NamedType(rootType.getRawType(), ai.findTypeName(rootType));
        if (rootNamedType != null) {
            seen.add(rootNamedType);
        }
        for (int i = 0; i < subtypes.size(); ++i) {
            List<NamedType> moreTypes;
            NamedType type = subtypes.get(i);
            AnnotatedClass ac = AnnotatedClass.constructWithoutSuperTypes(type.getType(), ai, config);
            if (!type.hasName()) {
                type.setName(ai.findTypeName(ac));
            }
            if ((moreTypes = ai.findSubtypes(ac)) == null) continue;
            for (NamedType t2 : moreTypes) {
                if (!seen.add(t2)) continue;
                subtypes.add(t2);
            }
        }
        if (rootNamedType != null) {
            subtypes.add(rootNamedType);
        }
        return subtypes;
    }
}

