/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.processes.examples.resampler;

import com.terradue.wps_hadoop.common.HadoopAbstractAlgorithm;
import com.terradue.wps_hadoop.processes.examples.resampler.ResamplerMapper;
import com.terradue.wps_hadoop.processes.examples.resampler.ResamplerReducer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.Reducer;
import org.apache.log4j.Logger;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

public class ResamplerAlgorithm
extends HadoopAbstractAlgorithm<LongWritable, Text> {
    private static Logger LOGGER = Logger.getLogger(ResamplerAlgorithm.class);
    public final UUID SessionUID = UUID.randomUUID();
    public final String wpsLocation = System.getProperty("catalina.base") + "/webapps/wps/";
    protected InetAddress addr;
    private List<String> errors = new ArrayList<String>();

    public List<String> getErrors() {
        return this.errors;
    }

    public Class getInputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public Class getOutputDataType(String id) {
        return LiteralStringBinding.class;
    }

    @Override
    public void prepareToRun(Map<String, List<IData>> inputData) {
        if (inputData == null || !inputData.containsKey("wcs_url")) {
            throw new RuntimeException("Error while allocating input parameters 'wcs_url'");
        }
        if (inputData == null || !inputData.containsKey("resolution")) {
            throw new RuntimeException("Error while allocating input parameters 'resolution'");
        }
        LOGGER.info((Object)"Preparation to run done");
    }

    @Override
    protected Class<? extends Mapper<?, ?, LongWritable, Text>> getMapper() {
        return ResamplerMapper.class;
    }

    @Override
    protected Class<? extends Reducer<LongWritable, Text, ?, ?>> getReducer() {
        return ResamplerReducer.class;
    }

    @Override
    protected JobConf getJobConf() {
        return new JobConf(((Object)((Object)this)).getClass());
    }

    @Override
    protected String getJobName() {
        return "resampler";
    }

    @Override
    protected Path[] getInputPaths(Map<String, List<IData>> inputData) {
        String wcs_url = ((LiteralStringBinding)inputData.get("wcs_url").get(0)).getPayload();
        String resolution = ((LiteralStringBinding)inputData.get("resolution").get(0)).getPayload();
        try {
            wcs_url = wcs_url.replaceAll("%25", "&");
            wcs_url = wcs_url.replaceAll("%", "&");
            LOGGER.info((Object)("WCS url = " + wcs_url));
            LOGGER.info((Object)("Session UID = " + this.SessionUID));
            String inputPath = this.wpsLocation + "/store/IMarine/local/inputs/" + this.SessionUID;
            File inputDir = new File(inputPath);
            LOGGER.info((Object)("inputDir mkdir " + inputDir.mkdirs()));
            File inputFile = new File(inputDir, "/inputFile");
            BufferedWriter buff = new BufferedWriter(new FileWriter(inputFile));
            LOGGER.info((Object)("Path " + inputFile.getPath()));
            buff.write(wcs_url + " " + this.getOutputPath() + " " + resolution);
            buff.close();
            this.hdfs = FileSystem.get((Configuration)this.hadoopConfig);
            this.hdfsPrefix = this.hdfs.getUri().toString();
            LOGGER.info((Object)("hdfsPrefix " + this.hdfsPrefix));
            Path inputHdfsPath = new Path(this.hdfsPrefix + this.wpsLocation + "/store/IMarine/hdfs/inputs/" + this.SessionUID);
            this.hdfs.copyFromLocalFile(false, true, new Path(inputFile.getPath()), inputHdfsPath);
            Path[] inputPaths = new Path[]{inputHdfsPath};
            return inputPaths;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error getting InputOutputPath " + e.getMessage(), e);
        }
    }

    @Override
    protected String getOutputPath() {
        return this.wpsLocation + "/store/IMarine/hdfs/outputs/" + this.SessionUID;
    }

    @Override
    protected Map<String, IData> buildResults() {
        String hostname = null;
        try {
            this.addr = InetAddress.getLocalHost();
            hostname = this.addr.getHostName();
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving host name " + e.getCause(), e);
        }
        String result = "http://" + hostname + ":8888/wps/store/IMarine/hdfs/outputs/" + this.SessionUID + "/result.tif";
        HashMap<String, IData> resulthash = new HashMap<String, IData>();
        resulthash.put("result", (IData)new LiteralStringBinding(result));
        try {
            this.hdfs.copyToLocalFile(new Path(this.getOutputPath()), new Path(this.wpsLocation + "/store/IMarine/local/outputs/" + this.SessionUID));
        }
        catch (IOException e) {
            throw new RuntimeException("Error building results ", e);
        }
        return resulthash;
    }

    public List<String> getInputIdentifiers() {
        ArrayList<String> identifierList = new ArrayList<String>();
        identifierList.add("wps_url");
        return identifierList;
    }

    public List<String> getOutputIdentifiers() {
        ArrayList<String> identifierList = new ArrayList<String>();
        identifierList.add("result");
        return identifierList;
    }
}

