/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.common;

import com.terradue.wps_hadoop.common.WCSClient;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.Resample;
import org.geotools.factory.Hints;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.Envelope2D;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValueGroup;

public class GeoTiffResampler {
    private static final ParameterValueGroup resampleParams;
    public static final Hints LENIENT_HINT;
    private static final Hints hints;
    private static final Resample resampleFactory;
    private static Logger LOGGER;

    public static void main(String[] args) {
        String endpoint = "http://t2-10-11-30-98.play.terradue.int:8080/thredds/wcs/maps/SST_MED_SST_L4_NRT_OBSERVATIONS_010_004_c_2011-11-03_2011-11-04.nc";
        String requestParameters = "service=WCS&version=1.0.0&request=GetCoverage&COVERAGE=analysed_sst&bbox=-18,20,36,45&width=100&height=100&format=geotiff";
        Double resolution = 0.0166692386831276;
        try {
            URL url = new URL(endpoint + "?" + requestParameters);
            GridCoverage2D coverage = GeoTiffResampler.resample(url, resolution);
            File tifFile = new File("test3.tif");
            try {
                GeoTiffWriter writer = new GeoTiffWriter((Object)tifFile);
                writer.write((GridCoverage)coverage, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Path resampleToTif(String url, Double resolution, String outputPath) {
        GridCoverage2D coverage;
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        try {
            LOGGER.info((Object)("URL resampling = " + url));
            coverage = GeoTiffResampler.resample(new URL(url), resolution);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
            return null;
        }
        try {
            Configuration config = new Configuration();
            FileSystem hdfs = FileSystem.get((Configuration)config);
            Path path = new Path(outputPath + "/result.tif");
            FSDataOutputStream outputStream = hdfs.create(path);
            GeoTiffWriter writer = new GeoTiffWriter((Object)outputStream);
            writer.write((GridCoverage)coverage, null);
            outputStream.close();
            return path;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static GridCoverage2D resample(URL url, Double resolution) {
        try {
            GridCoverage2D coverage = WCSClient.GetCoverage(url);
            String interpolationType = "Bilinear";
            ParameterValueGroup param = resampleParams.clone();
            param.parameter("Source").setValue((Object)coverage);
            GridGeometry2D curGridGeom = coverage.getGridGeometry();
            System.out.println("Geom " + curGridGeom.getEnvelope2D().getMinX());
            System.out.println("Geom " + curGridGeom.getEnvelope2D().getMaxX());
            Double maxX = curGridGeom.getEnvelope2D().getMaxX();
            Double minX = curGridGeom.getEnvelope2D().getMinX();
            Double minY = curGridGeom.getEnvelope2D().getMinY();
            Double maxY = curGridGeom.getEnvelope2D().getMaxY();
            Envelope2D curWorldEnv = curGridGeom.getEnvelope2D();
            GridEnvelope2D curGridEnv = curGridGeom.getGridRange2D();
            int newWidth = new Double((maxX - minX) / resolution).intValue();
            int newHeight = new Double((maxY - minY) / resolution).intValue();
            System.out.println("newWidth " + newWidth);
            GridEnvelope2D newGridEnv = new GridEnvelope2D(curGridEnv.x, curGridEnv.y, newWidth, newHeight);
            GridGeometry2D newGridGeom = new GridGeometry2D((GridEnvelope)newGridEnv, (Envelope)curWorldEnv);
            param.parameter("GridGeometry").setValue((Object)newGridGeom);
            param.parameter("InterpolationType").setValue((Object)interpolationType);
            return (GridCoverage2D)resampleFactory.doOperation(param, hints);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        LENIENT_HINT = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
        hints = new Hints();
        resampleFactory = new Resample();
        LOGGER = Logger.getLogger(GeoTiffResampler.class);
        hints.add((RenderingHints)LENIENT_HINT);
        CoverageProcessor processor = new CoverageProcessor();
        resampleParams = processor.getOperation("Resample").getParameters();
    }
}

