/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.examples.bathymetry;

import com.terradue.wps_hadoop.common.VTIBathymetry;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BathymetryMapper
extends MapReduceBase
implements Mapper<LongWritable, Text, LongWritable, Text> {
    public void map(LongWritable key, Text value, OutputCollector<LongWritable, Text> output, Reporter reporter) throws IOException {
        String fileName = "http://t2-10-11-30-97.play.terradue.int:8888/wps/maps/gebco_08.nc";
        VTIBathymetry bm = new VTIBathymetry(fileName);
        bm.debug = false;
        String line = value.toString();
        StringTokenizer tokenizer = new StringTokenizer(line);
        while (tokenizer.hasMoreTokens()) {
            Double x = Double.parseDouble(tokenizer.nextToken());
            Double y = Double.parseDouble(tokenizer.nextToken());
            String coordinates = "" + x.intValue() + "," + y.intValue();
            Short res = bm.get(x, y);
            coordinates = coordinates + "," + res;
            output.collect((Object)key, (Object)new Text(coordinates));
        }
    }
}

