/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.gtuploader;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ProgressAsyncHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GetStatusAsyncHandler
implements ProgressAsyncHandler<HttpResponseStatus> {
    private boolean failed = false;
    private HttpResponseStatus responseStatus;

    GetStatusAsyncHandler() {
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        return this.checkFailureAndReturnState();
    }

    public HttpResponseStatus onCompleted() throws Exception {
        return this.responseStatus;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        return this.checkFailureAndReturnState();
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus status) throws Exception {
        this.responseStatus = status;
        if (200 != status.getStatusCode() || 201 != status.getStatusCode()) {
            this.failed = true;
        }
        System.out.println("Done.");
        return this.checkFailureAndReturnState();
    }

    public void onThrowable(Throwable throwable) {
    }

    public AsyncHandler.STATE onContentWriteCompleted() {
        System.out.print("Done, waiting for Geoserver reply...\r");
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onContentWriteProgress(long amount, long current, long total) {
        System.out.print(100L * current / total + "%\r");
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onHeaderWriteCompleted() {
        return AsyncHandler.STATE.CONTINUE;
    }

    private AsyncHandler.STATE checkFailureAndReturnState() {
        if (this.failed) {
            return AsyncHandler.STATE.CONTINUE;
        }
        return AsyncHandler.STATE.ABORT;
    }
}

