/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client.internal.converters;

import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class LocaleConverter
implements Converter {
    private static final String SEPARATOR = "-";

    public Object convert(Class type, Object value) {
        if (value == null) {
            throw new ConversionException("Null values not supported in this version.");
        }
        if (String.class == type) {
            if (value instanceof Locale) {
                Locale locale = (Locale)value;
                return locale.getLanguage() + SEPARATOR + locale.getCountry();
            }
        } else if (Locale.class == type && value instanceof String) {
            StringTokenizer tokenizer = new StringTokenizer((String)value, SEPARATOR);
            return new Locale(tokenizer.nextToken(), tokenizer.nextToken());
        }
        throw new ConversionException(String.format("type %s and value %s not supported", type, value));
    }
}

