/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.handlers;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.lifetime.Lifetime;
import org.gcube.common.core.utils.handlers.lifetime.State;

public class GCUBEScheduledHandler<HANDLED>
extends GCUBEHandler<HANDLED>
implements Lifetime<HANDLED> {
    protected long interval;
    protected boolean repeat = true;
    protected Exception exception;
    protected int exceptionCount;
    private GCUBEHandler<HANDLED> scheduled;
    private Mode mode = Mode.EAGER;

    public GCUBEScheduledHandler() {
    }

    public GCUBEScheduledHandler(long interval, Mode mode, GCUBEHandler<HANDLED> ... handler) {
        this.setInterval(interval);
        this.setMode(mode);
        if (handler != null && handler.length > 0) {
            this.setScheduled(handler[0]);
        }
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval * 1000L;
    }

    public GCUBEHandler<HANDLED> getScheduled() {
        return this.scheduled;
    }

    public void setScheduled(GCUBEHandler<HANDLED> scheduled) {
        this.scheduled = scheduled;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Override
    public void run() throws Exception {
        if (this.getSecurityManager() != null) {
            this.getScheduled().setSecurityManager(this.getSecurityManager());
        }
        if (this.getScopeManager() != null) {
            this.getScheduled().setScopeManager(this.getScopeManager());
        }
        if (this.mode == Mode.EAGER) {
            boolean doNext = this.onIteration();
            if (this.exception != null) {
                throw new Exception(this.getScheduled().getName() + " has failed", this.exception);
            }
            if (!doNext) {
                return;
            }
        }
        this.setState(State.Running.INSTANCE);
        Thread schedulerThread = new Thread(this.getScheduled().getName()){

            @Override
            public void run() {
                do {
                    try {
                        GCUBEScheduledHandler.this.setState(State.Suspended.INSTANCE);
                        Thread.sleep(GCUBEScheduledHandler.this.interval);
                    }
                    catch (Exception e) {
                        GCUBEScheduledHandler.this.logger.warn("some unlikely problem", e);
                    }
                } while (GCUBEScheduledHandler.this.onIteration());
                GCUBEScheduledHandler.this.setState(State.Done.INSTANCE);
            }
        };
        if (this.getSecurityManager() != null) {
            this.getSecurityManager().useCredentials(schedulerThread, new SecurityCredentials[0]);
        }
        if (this.getScopeManager() != null && this.getScopeManager().getScope() != null) {
            this.getScopeManager().setScope(schedulerThread, new GCUBEScope[0]);
        }
        schedulerThread.setDaemon(true);
        schedulerThread.start();
    }

    protected boolean onIteration() {
        this.setState(State.Running.INSTANCE);
        this.exception = null;
        try {
            if (this.getScheduled() != null) {
                this.getScheduled().run();
            }
            this.exceptionCount = 0;
        }
        catch (Exception e) {
            this.exception = e;
            ++this.exceptionCount;
        }
        return this.repeat && this.repeat(this.exception, this.exceptionCount);
    }

    public void stop() {
        this.repeat = false;
    }

    protected boolean repeat(Exception exception, int exceptionCount) {
        if (exception != null) {
            this.logger.error(this.getScheduled().getName() + " has failed", exception);
            this.setState(State.Failed.INSTANCE);
            return false;
        }
        return true;
    }

    public static enum Mode {
        EAGER,
        LAZY;

    }
}

