/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.scope;

import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.common.core.scope.ServiceMap;
import org.gcube.common.core.scope.VO;
import org.gcube.common.core.scope.VRE;

public abstract class GCUBEScope {
    protected static char pathSeparator = (char)47;
    private String name;
    private Type type;
    protected ServiceMap serviceMap;
    private GCUBEScope enclosingScope;

    public static GCUBEScope getScope(String exp) throws MalformedScopeExpressionException {
        ScopeExpression expression = new ScopeExpression(exp);
        VO infrastructure = new VO(expression.getInfrastructure());
        infrastructure.type = Type.INFRASTRUCTURE;
        if (expression.getVO() != null) {
            VO vo = new VO(expression.getVO());
            vo.setEnclosingScope(infrastructure);
            vo.type = Type.VO;
            if (expression.getVRE() != null) {
                VRE vre = new VRE(expression.getVRE());
                vre.setEnclosingScope(vo);
                vre.type = Type.VRE;
                return vre;
            }
            return vo;
        }
        return infrastructure;
    }

    public void makeCurrent() {
        GCUBEScopeManager.DEFAULT.setScope(this);
    }

    public GCUBEScope getInfrastructure() {
        if (this.isInfrastructure()) {
            return this;
        }
        return this.getEnclosingScope().getInfrastructure();
    }

    protected GCUBEScope(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public GCUBEScope getEnclosingScope() {
        return this.enclosingScope;
    }

    public boolean isInfrastructure() {
        return this.getEnclosingScope() == null;
    }

    protected void setEnclosingScope(GCUBEScope enclosingScope) {
        this.enclosingScope = enclosingScope;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.isInfrastructure() ? pathSeparator + this.getName() : this.getEnclosingScope().toString() + pathSeparator + this.getName();
    }

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public boolean isEnclosedIn(GCUBEScope scope) {
        int check = this.getType().compareTo(scope.getType());
        if (check == 0) {
            return this.equals(scope);
        }
        if (check < 0) {
            return this.getEnclosingScope().isEnclosedIn(scope);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public abstract ServiceMap getServiceMap() throws GCUBEScopeNotSupportedException;

    public void setServiceMap(ServiceMap map) {
    }

    public static class ScopeExpression {
        private String VO;
        private String infrastructure;
        private String VRE;

        public ScopeExpression(String expression) throws MalformedScopeExpressionException {
            String[] components = expression.split("/");
            if (components.length > 1) {
                this.VO = components[1];
            }
            if (components.length > 2) {
                this.infrastructure = components[2];
            }
            if (components.length > 3) {
                this.VRE = components[3];
            }
            if (components.length < 2 || components.length > 4) {
                throw new MalformedScopeExpressionException();
            }
        }

        public String getInfrastructure() {
            return this.VO;
        }

        public String getVO() {
            return this.infrastructure;
        }

        public String getVRE() {
            return this.VRE;
        }
    }

    public static class MalformedScopeExpressionException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public MalformedScopeExpressionException() {
        }

        public MalformedScopeExpressionException(String msg) {
            super(msg);
        }
    }

    public static enum Type implements Comparable<Type>
    {
        VRE,
        VO,
        INFRASTRUCTURE;

    }
}

