/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.scope.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class ServiceMapAdapter
extends XmlAdapter<ValueServiceMap, Map<String, List<String>>> {
    public Map<String, List<String>> unmarshal(ValueServiceMap valueMap) throws Exception {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        for (ServiceEntry service : valueMap.services) {
            map.put(service.name, service.endpoints);
        }
        return map;
    }

    public ValueServiceMap marshal(Map<String, List<String>> map) throws Exception {
        ValueServiceMap valueMap = new ValueServiceMap();
        for (Map.Entry<String, List<String>> e : map.entrySet()) {
            ServiceEntry entry = new ServiceEntry();
            entry.name = e.getKey();
            entry.endpoints = e.getValue();
        }
        return valueMap;
    }

    static class ServiceEntry {
        @XmlAttribute
        private String name;
        @XmlElement(name="endpoint")
        private List<String> endpoints;

        ServiceEntry() {
        }
    }

    @XmlRootElement(name="services")
    static class ValueServiceMap {
        @XmlElement(name="service")
        Set<ServiceEntry> services;

        ValueServiceMap() {
        }
    }
}

