/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;

public class KeyValueLineRecordReader
extends RecordReader<Text, Text> {
    private final LineRecordReader lineRecordReader;
    private byte separator = (byte)9;
    private Text innerValue;
    private Text key;
    private Text value;

    public Class<?> getKeyClass() {
        return Text.class;
    }

    public KeyValueLineRecordReader(Configuration conf) throws IOException {
        this.lineRecordReader = new LineRecordReader();
        String sepStr = conf.get("key.value.separator.in.input.line", "\t");
        this.separator = (byte)sepStr.charAt(0);
    }

    @Override
    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        this.lineRecordReader.initialize(genericSplit, context);
    }

    public static int findSeparator(byte[] utf, int start, int length, byte sep) {
        for (int i = start; i < start + length; ++i) {
            if (utf[i] != sep) continue;
            return i;
        }
        return -1;
    }

    public static void setKeyValue(Text key, Text value, byte[] line, int lineLen, int pos) {
        if (pos == -1) {
            key.set(line, 0, lineLen);
            value.set("");
        } else {
            int keyLen = pos;
            byte[] keyBytes = new byte[keyLen];
            System.arraycopy(line, 0, keyBytes, 0, keyLen);
            int valLen = lineLen - keyLen - 1;
            byte[] valBytes = new byte[valLen];
            System.arraycopy(line, pos + 1, valBytes, 0, valLen);
            key.set(keyBytes);
            value.set(valBytes);
        }
    }

    @Override
    public synchronized boolean nextKeyValue() throws IOException {
        byte[] line = null;
        int lineLen = -1;
        if (!this.lineRecordReader.nextKeyValue()) {
            return false;
        }
        this.innerValue = this.lineRecordReader.getCurrentValue();
        line = this.innerValue.getBytes();
        lineLen = this.innerValue.getLength();
        if (line == null) {
            return false;
        }
        if (this.key == null) {
            this.key = new Text();
        }
        if (this.value == null) {
            this.value = new Text();
        }
        int pos = KeyValueLineRecordReader.findSeparator(line, 0, lineLen, this.separator);
        KeyValueLineRecordReader.setKeyValue(this.key, this.value, line, lineLen, pos);
        return true;
    }

    @Override
    public Text getCurrentKey() {
        return this.key;
    }

    @Override
    public Text getCurrentValue() {
        return this.value;
    }

    @Override
    public float getProgress() {
        return this.lineRecordReader.getProgress();
    }

    @Override
    public synchronized void close() throws IOException {
        this.lineRecordReader.close();
    }
}

