/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.Base64;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.util.I18n;
import org.globus.wsrf.NoResourceHomeException;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.GridMapAuthorization;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.authorization.IdentityAuthorization;
import org.globus.wsrf.impl.security.authorization.NoAuthorization;
import org.globus.wsrf.impl.security.authorization.SAMLAuthorizationCallout;
import org.globus.wsrf.impl.security.authorization.SelfAuthorization;
import org.globus.wsrf.impl.security.authorization.UsernameAuthorization;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.impl.security.util.FixedObjectInputStream;
import org.globus.wsrf.security.SecurityException;
import org.globus.wsrf.security.authorization.PDP;
import org.globus.wsrf.utils.ContextUtils;
import org.globus.wsrf.utils.XmlUtils;
import org.ietf.jgss.GSSCredential;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuthUtil {
    private static Log logger = LogFactory.getLog(AuthUtil.class.getName());
    private static I18n i18n = I18n.getI18n("org.globus.wsrf.impl.security.error", AuthUtil.class.getClassLoader());
    public static final String EPR_DELIMITER = "?";

    public static GSSCredential getCredential(javax.xml.rpc.handler.MessageContext ctx) throws SecurityException {
        Object tmp = ctx.getProperty("org.globus.gsi.credentials");
        if (tmp == null || tmp instanceof GSSCredential) {
            return (GSSCredential)tmp;
        }
        throw new SecurityException(i18n.getMessage("invalidType", new Object[]{"org.globus.gsi.credentials", GSSCredential.class.getName()}));
    }

    public static Authorization getClientAuthorization(javax.xml.rpc.handler.MessageContext ctx) throws SecurityException {
        Object tmp = ctx.getProperty("org.globus.security.authorization");
        if (tmp == null || tmp instanceof Authorization) {
            return (Authorization)tmp;
        }
        String err = i18n.getMessage("invalidType", new Object[]{"org.globus.security.authorization", Authorization.class.getName()});
        throw new SecurityException(err);
    }

    public static Authorization getClientAuthorization(String authzString) {
        PDP authz = null;
        if (authzString == null) {
            return null;
        }
        authz = authzString.equals("none") ? NoAuthorization.getInstance() : (authzString.equals("self") ? new SelfAuthorization() : (authzString.equals("host") ? HostAuthorization.getInstance() : new IdentityAuthorization(authzString)));
        return authz;
    }

    public static String getPDPName(String authz) {
        if (authz == null) {
            return null;
        }
        if (authz.equals("none")) {
            return "noneAuthz:" + NoAuthorization.class.getName();
        }
        if (authz.equals("self")) {
            return "selfAuthz:" + SelfAuthorization.class.getName();
        }
        if (authz.equals("gridmap")) {
            return "gridmapAuthz:" + GridMapAuthorization.class.getName();
        }
        if (authz.equals("identity")) {
            return "idenAuthz:" + IdentityAuthorization.class.getName();
        }
        if (authz.equals("host")) {
            return "hostAuthz:" + HostAuthorization.class.getName();
        }
        if (authz.equals("samlCallout")) {
            return "samlAuthz:" + SAMLAuthorizationCallout.class.getName();
        }
        if (authz.equals("userName")) {
            return "userNameAuthz:" + UsernameAuthorization.class.getName();
        }
        return authz;
    }

    public static String substitutePDPNames(String authzString) {
        if (authzString == null) {
            return null;
        }
        StringTokenizer strTok = new StringTokenizer(authzString);
        if (strTok.hasMoreTokens()) {
            String tok = strTok.nextToken();
            StringBuffer interceptorStringBuf = new StringBuffer(AuthUtil.getPDPName(tok));
            while (strTok.hasMoreTokens()) {
                tok = strTok.nextToken();
                interceptorStringBuf.append(" ").append(AuthUtil.getPDPName(tok));
            }
            return interceptorStringBuf.toString();
        }
        return null;
    }

    public static String getIdentity(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set principals = subject.getPrincipals(GlobusPrincipal.class);
        if (principals == null || principals.isEmpty()) {
            return null;
        }
        Iterator iter = principals.iterator();
        GlobusPrincipal principal = (GlobusPrincipal)iter.next();
        return principal.toString();
    }

    public static URL getEndpointAddressURL(javax.xml.rpc.handler.MessageContext ctx) throws MalformedURLException {
        return new URL(AuthUtil.getEndpointAddress(ctx));
    }

    public static String getEndpointAddress(javax.xml.rpc.handler.MessageContext ctx) {
        String endpoint = (String)ctx.getProperty("transport.url");
        if (endpoint == null) {
            endpoint = (String)ctx.getProperty("javax.xml.rpc.service.endpoint.address");
        }
        return endpoint;
    }

    public static QName getOperationName(MessageContext messageContext) throws AxisFault, SecurityException {
        Message msg = messageContext.getCurrentMessage();
        SOAPEnvelope env = msg.getSOAPEnvelope();
        SOAPBodyElement body = env.getFirstBody();
        QName paramQName = body.getQName();
        logger.debug("Trying to find " + paramQName);
        SOAPService service = messageContext.getService();
        if (service == null) {
            throw new AxisFault(Constants.QNAME_NO_SERVICE_FAULT_CODE, i18n.getMessage("noService", messageContext.getTargetService()), null, null);
        }
        ServiceDesc serviceDesc = service.getServiceDescription();
        ArrayList operations = serviceDesc.getOperations();
        for (int i = 0; i < operations.size(); ++i) {
            OperationDesc operation = (OperationDesc)operations.get(i);
            logger.debug("Operation in question " + operation.getElementQName());
            ParameterDesc desc = operation.getParamByQName(paramQName);
            if (desc == null) continue;
            return operation.getElementQName();
        }
        throw new SecurityException(i18n.getMessage("operationNameIndeterminate"));
    }

    public static String getSecurityDescFile(String servicePath) throws SecurityException {
        MessageContext ctx = MessageContext.getCurrentContext();
        return ctx != null ? AuthUtil.getSecurityDescFile(ctx, servicePath) : null;
    }

    public static String getSecurityDescFile(MessageContext msgCtx, String servicePath) throws SecurityException {
        try {
            return (String)ContextUtils.getServiceProperty(msgCtx, servicePath, "securityDescriptor");
        }
        catch (AxisFault af) {
            throw new SecurityException(af);
        }
    }

    public static void initializeSecurityDesc(MessageContext msgCtx, String servicePath) throws SecurityException {
        try {
            ContainerSecurityConfig config = ContainerSecurityConfig.getConfig();
            String descFile = AuthUtil.getSecurityDescFile(msgCtx, servicePath);
            logger.debug("Descriptor file for " + servicePath + " is " + descFile);
            ServiceSecurityConfig.initialize(servicePath, descFile);
        }
        catch (ConfigException exp) {
            throw new SecurityException(exp);
        }
    }

    public static AddressingHeaders getAddressingHeaders(MessageContext ctx) {
        return (AddressingHeaders)ctx.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
    }

    public static String getEPRAsString(MessageContext ctx) throws SecurityException {
        AddressingHeaders addressingHeaders = AuthUtil.getAddressingHeaders(ctx);
        return AuthUtil.getEPRAsString(addressingHeaders, ctx);
    }

    public static String getEPRAsString(AddressingHeaders addressingHeaders, MessageContext ctx) throws SecurityException {
        if (addressingHeaders == null) {
            throw new IllegalArgumentException(i18n.getMessage("noAddHeader"));
        }
        String resource = addressingHeaders.getTo().toString();
        if (addressingHeaders.getReferenceProperties().size() == 0) {
            return resource;
        }
        return AuthUtil.getEPRAsString(resource, ctx);
    }

    public static String getEPRAsString(String serviceEndpoint, MessageContext ctx) throws SecurityException {
        SOAPHeaderElement resHeader = null;
        try {
            resHeader = AuthUtil.getResourceHeader(ctx);
        }
        catch (NoResourceHomeException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Found no resource home for service " + serviceEndpoint, e);
            }
            return serviceEndpoint;
        }
        catch (ResourceContextException exp) {
            throw new SecurityException(i18n.getMessage("resourceHeaderError"), exp);
        }
        return AuthUtil.getEPRAsString(resHeader, serviceEndpoint);
    }

    public static String getEPRAsString(SOAPHeaderElement resHeader, String resource) throws SecurityException {
        String resHeaderDigest = AuthUtil.getResourceHeaderDigest(resHeader);
        if (resHeaderDigest != null) {
            resHeaderDigest = URLEncoder.encode(resHeaderDigest);
            resource = resource + EPR_DELIMITER + resHeaderDigest;
        }
        logger.debug("EPR is : " + resource);
        return resource;
    }

    public static String getResourceHeaderDigest(MessageContext ctx) throws SecurityException {
        if (ctx == null) {
            throw new IllegalArgumentException(i18n.getMessage("noContext"));
        }
        SOAPHeaderElement resHeader = null;
        try {
            resHeader = AuthUtil.getResourceHeader(ctx);
        }
        catch (ResourceContextException exp) {
            throw new SecurityException(i18n.getMessage("resourceHeaderError"), exp);
        }
        return AuthUtil.getResourceHeaderDigest(resHeader);
    }

    public static String getResourceHeaderDigest(SOAPHeaderElement resHeader) throws SecurityException {
        if (resHeader == null) {
            return null;
        }
        Document doc = null;
        Element importedNode = null;
        try {
            doc = XmlUtils.newDocument();
            importedNode = (Element)doc.importNode(((MessageElement)((Object)resHeader)).getAsDOM(), true);
        }
        catch (Exception exp) {
            throw new SecurityException(i18n.getMessage("resHeaderElement"), exp);
        }
        byte[] c14nBytes = null;
        try {
            Canonicalizer c14n = Canonicalizer.getInstance("http://www.w3.org/2001/10/xml-exc-c14n#");
            c14nBytes = c14n.canonicalizeSubtree(importedNode);
        }
        catch (CanonicalizationException exp) {
            throw new SecurityException(i18n.getMessage("c14nError"), exp);
        }
        catch (InvalidCanonicalizerException exp) {
            throw new SecurityException(i18n.getMessage("c14nError"), exp);
        }
        MessageDigestAlgorithm mda = null;
        try {
            mda = MessageDigestAlgorithm.getInstance(doc, "http://www.w3.org/2000/09/xmldsig#sha1");
        }
        catch (XMLSignatureException exp) {
            throw new SecurityException(i18n.getMessage("mdaError"), exp);
        }
        mda.reset();
        mda.update(c14nBytes);
        byte[] digest = mda.digest();
        return Base64.encode(digest);
    }

    public static SOAPHeaderElement getResourceHeader(MessageContext ctx) throws ResourceContextException {
        ResourceContext context = ResourceContext.getResourceContext(ctx);
        return context.getResourceKeyHeader();
    }

    public static void writeSubject(Subject subject, ObjectOutputStream oos) throws SecurityException {
        try {
            Set<Object> privateCreds;
            oos.writeObject(subject);
            if (subject == null) {
                return;
            }
            Set<Object> publicCreds = subject.getPublicCredentials();
            if (publicCreds != null && !publicCreds.isEmpty()) {
                Vector<Object> vector = new Vector<Object>(publicCreds);
                oos.writeObject(vector);
            }
            if ((privateCreds = subject.getPrivateCredentials()) != null && !privateCreds.isEmpty()) {
                Vector<Object> vector = new Vector<Object>(privateCreds);
                oos.writeObject(vector);
            }
        }
        catch (IOException exp) {
            throw new SecurityException(exp);
        }
    }

    public static Subject readSubject(FixedObjectInputStream ois) throws SecurityException, ClassNotFoundException {
        Subject subject = null;
        try {
            subject = (Subject)ois.readObject();
            Vector publicCreds = (Vector)ois.readObject();
            subject.getPublicCredentials().addAll(publicCreds);
            Vector privateCreds = (Vector)ois.readObject();
            subject.getPrivateCredentials().addAll(privateCreds);
        }
        catch (IOException exp) {
            throw new SecurityException(exp);
        }
        return subject;
    }
}

