/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import org.globus.wsrf.container.LockManager;

public class Lock
extends ReentrantLock {
    protected boolean removingLock;
    private LockManager lockManager;
    private Object key;

    public Lock(LockManager lockManager, Object key) {
        this.lockManager = lockManager;
        this.key = key;
        this.removingLock = false;
    }

    public boolean acquire(boolean removingLock) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.acquire(Thread.currentThread(), removingLock);
    }

    protected synchronized boolean acquire(Thread caller, boolean removingLock) throws InterruptedException {
        if (this.owner_ == null) {
            this.owner_ = caller;
            this.holds_ = 1L;
            this.removingLock = removingLock;
            return true;
        }
        if (this.owner_ == caller) {
            ++this.holds_;
            return true;
        }
        if (this.removingLock) {
            return false;
        }
        try {
            while (this.owner_ != null) {
                this.wait();
            }
            this.owner_ = caller;
            this.holds_ = 1L;
            this.removingLock = removingLock;
        }
        catch (InterruptedException ex) {
            this.notify();
            throw ex;
        }
        return true;
    }

    public synchronized void release() {
        if (Thread.currentThread() != this.owner_) {
            throw new Error("Illegal Lock usage");
        }
        --this.holds_;
        if (this.holds_ == 0L) {
            this.reset();
        }
    }

    public synchronized void release(long n) {
        if (Thread.currentThread() != this.owner_ || n > this.holds_) {
            throw new Error("Illegal Lock usage");
        }
        this.holds_ -= n;
        if (this.holds_ == 0L) {
            this.reset();
        }
    }

    protected synchronized void reset() {
        this.owner_ = null;
        this.removingLock = false;
        if (this.lockManager != null) {
            this.lockManager.removeLock(this.key);
        }
        this.notify();
    }
}

