/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.client;

import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.client.BaseClient;
import org.globus.wsrf.core.notification.ResourcePropertyValueChangeNotificationElementType;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.FaultHelper;
import org.globus.wsrf.utils.XmlUtils;
import org.oasis.wsn.NotificationProducer;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsn.WSBaseNotificationServiceAddressingLocator;
import org.oasis.wsrf.properties.ResourcePropertyValueChangeNotificationType;
import org.w3c.dom.Element;

public class Subscribe
extends BaseClient
implements NotifyCallback {
    private static final QName NAME = new QName("", "SubscriptionReference");
    private static final Option SUB_EPR_FILE;
    private static final Option RES_DESC_FILE;

    public Subscribe() {
        this.options.addOption(SUB_EPR_FILE);
        this.options.addOption(RES_DESC_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String resDescFilename = null;
        Subscribe client = new Subscribe();
        client.setCustomUsage("topic");
        CommandLine line = null;
        QName topicQName = null;
        try {
            line = client.parse(args);
            List options = line.getArgList();
            if (options == null || options.isEmpty()) {
                throw new ParseException("topic name expected");
            }
            topicQName = QName.valueOf((String)options.get(0));
        }
        catch (ParseException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        WSBaseNotificationServiceAddressingLocator locator = new WSBaseNotificationServiceAddressingLocator();
        NotificationConsumerManager consumer = null;
        int exitCode = 0;
        try {
            NotificationProducer port = locator.getNotificationProducerPort(client.getEPR());
            client.setOptions((Stub)((Object)port));
            consumer = NotificationConsumerManager.getInstance();
            consumer.startListening();
            if (line.hasOption("r")) {
                resDescFilename = line.getOptionValue("r");
            }
            ResourceSecurityDescriptor resDesc = null;
            if (resDescFilename != null) {
                ResourceSecurityConfig config = new ResourceSecurityConfig(resDescFilename);
                config.init();
                resDesc = config.getSecurityDescriptor();
            }
            EndpointReferenceType consumerEPR = consumer.createNotificationConsumer(client, resDesc);
            TopicExpressionType topicExpression = new TopicExpressionType();
            topicExpression.setDialect("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple");
            topicExpression.setValue(topicQName);
            org.oasis.wsn.Subscribe request = new org.oasis.wsn.Subscribe();
            request.setUseNotify(Boolean.TRUE);
            request.setConsumerReference(consumerEPR);
            request.setTopicExpression(topicExpression);
            SubscribeResponse response = port.subscribe(request);
            System.out.println("Subscription successful");
            EndpointReferenceType epr = response.getSubscriptionReference();
            System.out.println(epr);
            if (line.hasOption("b")) {
                FileWriter out = null;
                try {
                    out = new FileWriter(line.getOptionValue("b"));
                    ObjectSerializer.serialize(out, epr, NAME);
                    out.write(10);
                }
                catch (IOException e) {
                    System.err.println("Failed to write subscription epr: " + e.getMessage());
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception ee) {}
                    }
                }
            }
            org.oasis.wsn.Subscribe subscribe = request;
            synchronized (subscribe) {
                request.wait();
            }
        }
        catch (Exception e) {
            if (client.isDebugMode()) {
                FaultHelper.printStackTrace(e);
            } else {
                System.err.println("Error: " + FaultHelper.getMessage(e));
            }
            exitCode = 2;
        }
        finally {
            if (consumer != null) {
                try {
                    consumer.stopListening();
                }
                catch (Exception ee) {}
            }
        }
        System.exit(exitCode);
    }

    public void deliver(List topicPath, EndpointReferenceType producer, Object message) {
        if (message instanceof ResourcePropertyValueChangeNotificationElementType) {
            ResourcePropertyValueChangeNotificationType changeMessage = ((ResourcePropertyValueChangeNotificationElementType)message).getResourcePropertyValueChangeNotification();
            System.out.println("Received:");
            try {
                System.out.println(AnyHelper.toSingleString(changeMessage.getNewValue()));
            }
            catch (Exception e) {
                System.err.println("Error converting: " + e.getMessage());
            }
        } else if (message instanceof Element) {
            System.out.println("Received:");
            System.out.println(XmlUtils.toString((Element)message));
        } else {
            System.out.println("Received message of type: " + message.getClass().getName());
        }
    }

    static {
        OptionBuilder.withArgName("file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Save subscription EPR");
        OptionBuilder.withLongOpt("subEpr");
        SUB_EPR_FILE = OptionBuilder.create("b");
        OptionBuilder.withArgName("file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Resource descriptor file for consumer security");
        OptionBuilder.withLongOpt("resDescFile");
        RES_DESC_FILE = OptionBuilder.create("r");
    }
}

