/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.gsi.jndi;

import com.sun.security.sasl.preview.SaslClient;
import com.sun.security.sasl.preview.SaslException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.mds.gsi.common.GSIMechanism;
import org.ietf.jgss.GSSException;

public class GSIMech
extends GSIMechanism
implements SaslClient {
    private static Log logger = LogFactory.getLog((class$org$globus$mds$gsi$jndi$GSIMech == null ? (class$org$globus$mds$gsi$jndi$GSIMech = GSIMech.class$("org.globus.mds.gsi.jndi.GSIMech")) : class$org$globus$mds$gsi$jndi$GSIMech).getName());
    static /* synthetic */ Class class$org$globus$mds$gsi$jndi$GSIMech;

    public GSIMech(String authzID, String protocol, String serverName, Map props, CallbackHandler cbh) throws SaslException {
        if (props != null) {
            String prop = (String)props.get("javax.security.sasl.maxbuffer");
            if (prop != null) {
                try {
                    this.recvMaxBufSize = Integer.parseInt(prop);
                }
                catch (NumberFormatException e) {
                    throw new SaslException("Property must be string representation of integer: javax.security.sasl.maxbuffer");
                }
            }
            if ((prop = (String)props.get("javax.security.sasl.sendmaxbuffer")) != null) {
                try {
                    this.sendMaxBufSize = Integer.parseInt(prop);
                }
                catch (NumberFormatException e) {
                    throw new SaslException("Property must be string representation of integer: javax.security.sasl.sendmaxbuffer");
                }
            }
        }
        try {
            this.init(serverName, props);
        }
        catch (Exception e) {
            throw new SaslException("Failed to initialize", (Throwable)e);
        }
    }

    public boolean hasInitialResponse() {
        return true;
    }

    public byte[] evaluateChallenge(byte[] challengeData) throws SaslException {
        if (challengeData == null) {
            throw new SaslException("Received null challenge data");
        }
        byte[] token = null;
        try {
            token = this.exchangeData(challengeData);
        }
        catch (GSSException e) {
            throw new SaslException("evaluateChanllenge failed", (Throwable)e);
        }
        catch (Exception e) {
            throw new SaslException("evaluateChanllenge failed", (Throwable)e);
        }
        return token;
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        try {
            return this.context.wrap(outgoing, offset, len, null);
        }
        catch (GSSException e) {
            throw new SaslException("wrap failed", (Throwable)e);
        }
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        try {
            return this.context.unwrap(incoming, offset, len, null);
        }
        catch (GSSException e) {
            throw new SaslException("unwrap failed", (Throwable)e);
        }
    }

    public void dispose() throws SaslException {
        logger.debug("dispose");
        try {
            this.context.dispose();
        }
        catch (GSSException e) {
            throw new SaslException("dispose failed", (Throwable)e);
        }
    }

    public String getNegotiatedProperty(String propName) throws SaslException {
        logger.debug("getNegotiatedProperty: " + propName);
        if (propName.equals("javax.security.sasl.qop")) {
            if (this.isPrivacyQop()) {
                return "auth-conf";
            }
            if (this.isIntegrityQop()) {
                return "auth-int";
            }
            return "auth";
        }
        if (propName.equals("javax.security.sasl.maxbuffer")) {
            return Integer.toString(this.getRecvMaxBufSize());
        }
        if (propName.equals("javax.security.sasl.sendmaxbuffer")) {
            return Integer.toString(this.getSendMaxBufSize());
        }
        return null;
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

