/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.examples.resampler;

import com.terradue.wps_hadoop.common.HadoopAbstractAlgorithm;
import com.terradue.wps_hadoop.examples.resampler.ResamplerMapper;
import com.terradue.wps_hadoop.examples.resampler.ResamplerReducer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.Reducer;
import org.apache.log4j.Logger;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

public class ResamplerAlgorithm
extends HadoopAbstractAlgorithm<LongWritable, Text> {
    private static Logger LOGGER = Logger.getLogger(ResamplerAlgorithm.class);
    public final UUID SessionUID = UUID.randomUUID();
    public final String wpsLocation = String.valueOf(System.getProperty("catalina.base")) + "/webapps/wps";
    protected InetAddress addr;
    private List<String> errors = new ArrayList<String>();

    public List<String> getErrors() {
        return this.errors;
    }

    public Class getInputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public Class getOutputDataType(String id) {
        return LiteralStringBinding.class;
    }

    @Override
    public void prepareToRun(Map<String, List<IData>> inputData) {
        this.startElapsedTime = System.currentTimeMillis();
        if (inputData == null || !inputData.containsKey("wcs_url")) {
            throw new RuntimeException("Error while allocating input parameters 'wcs_url'");
        }
        if (inputData == null || !inputData.containsKey("resolution")) {
            throw new RuntimeException("Error while allocating input parameters 'resolution'");
        }
        LOGGER.info((Object)"Preparation to run done");
    }

    @Override
    protected Class<? extends Mapper<?, ?, LongWritable, Text>> getMapper() {
        return ResamplerMapper.class;
    }

    @Override
    protected Class<? extends Reducer<LongWritable, Text, ?, ?>> getReducer() {
        return ResamplerReducer.class;
    }

    @Override
    protected JobConf getJobConf() {
        return new JobConf(((Object)((Object)this)).getClass());
    }

    @Override
    protected String getJobName() {
        return "resampler";
    }

    @Override
    protected Path[] getInputPaths(Map<String, List<IData>> inputData) {
        String wcs_url = ((LiteralStringBinding)inputData.get("wcs_url").get(0)).getPayload();
        String resolution = ((LiteralStringBinding)inputData.get("resolution").get(0)).getPayload();
        try {
            wcs_url = wcs_url.replaceAll("%25", "&");
            wcs_url = wcs_url.replaceAll("%", "&");
            LOGGER.info((Object)("WCS url = " + wcs_url));
            LOGGER.info((Object)("Session UID = " + this.SessionUID));
            String inputPath = String.valueOf(this.wpsLocation) + "/store/IMarine/local/inputs/" + this.SessionUID;
            File inputDir = new File(inputPath);
            LOGGER.info((Object)("inputDir mkdir " + inputDir.mkdirs()));
            File inputFile = new File(inputDir, "/inputFile");
            BufferedWriter buff = new BufferedWriter(new FileWriter(inputFile));
            LOGGER.info((Object)("Path " + inputFile.getPath()));
            buff.write(String.valueOf(wcs_url) + " " + this.getOutputPath() + " " + resolution);
            buff.close();
            this.hdfs = FileSystem.get((Configuration)this.hadoopConfig);
            this.hdfsPrefix = this.hdfs.getUri().toString();
            LOGGER.info((Object)("hdfsPrefix " + this.hdfsPrefix));
            Path inputHdfsPath = new Path(String.valueOf(this.hdfsPrefix) + this.wpsLocation + "/store/IMarine/hdfs/inputs/" + this.SessionUID);
            this.hdfs.copyFromLocalFile(false, true, new Path(inputFile.getPath()), inputHdfsPath);
            Path[] inputPaths = new Path[]{inputHdfsPath};
            return inputPaths;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error getting InputOutputPath " + e.getMessage(), e);
        }
    }

    @Override
    protected String getOutputPath() {
        return String.valueOf(this.wpsLocation) + "/store/IMarine/hdfs/outputs/" + this.SessionUID;
    }

    @Override
    protected Map<String, IData> buildResults() {
        String hostname = null;
        try {
            this.addr = InetAddress.getLocalHost();
            hostname = this.addr.getHostName();
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving host name " + e.getCause(), e);
        }
        HashMap<String, IData> resulthash = new HashMap<String, IData>();
        try {
            this.hdfs.copyToLocalFile(new Path(this.getOutputPath()), new Path(String.valueOf(this.wpsLocation) + "/store/IMarine/local/outputs/" + this.SessionUID));
            String remoteFile = "/store/IMarine/local/outputs/" + this.SessionUID + "/result.tif";
            String remoteFileInSM = "/store/IMarine/local/outputs/test/result.tif";
            String result = "";
            String[] server = new String[]{"146.48.122.153", "146.48.122.138"};
            try {
                LOGGER.info((Object)"StorageManager invokation");
                String clientID = "devsec/wps";
                ServiceEngine client = new ServiceEngine(server, clientID, "devsec", "shared", "resampler");
                LOGGER.info((Object)"StorageManager client builded");
                String localFile = String.valueOf(this.wpsLocation) + "/store/IMarine/local/outputs/" + this.SessionUID + "/result.tif";
                LOGGER.info((Object)("localFile: " + localFile + "  remoteFile: " + remoteFile));
                LOGGER.info((Object)("localFile: " + localFile + "  remoteFile in SM: " + remoteFileInSM));
                client.put(true).LFile(localFile).RFile(remoteFileInSM);
                LOGGER.info((Object)"StorageManager file uploaded");
                result = client.getUrl().RFile(remoteFileInSM);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            resulthash.put("result", (IData)new LiteralStringBinding(result));
        }
        catch (IOException e) {
            throw new RuntimeException("Error building results ", e);
        }
        this.endTime = System.currentTimeMillis();
        LOGGER.info((Object)("Elapsed Time " + (this.endTime - this.startElapsedTime) / 1000.0 + " secs"));
        return resulthash;
    }
}

