/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.kxml.mcollection;

import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Calendar;
import org.gcube.common.core.resources.GCUBEMCollection;
import org.gcube.common.resources.kxml.GCUBEResourceImpl;
import org.gcube.common.resources.kxml.KGCUBEResource;
import org.gcube.common.resources.kxml.utils.KBoolean;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class KGCUBEMCollection
extends GCUBEMCollection
implements GCUBEResourceImpl {
    @Override
    public synchronized void load(Reader reader) throws Exception {
        KGCUBEResource.load(this, reader);
    }

    @Override
    public synchronized void store(Writer writer) throws Exception {
        KGCUBEResource.store(this, writer);
    }

    @Override
    public InputStream getSchemaResource() {
        return KGCUBEMCollection.class.getResourceAsStream("/org/gcube/common/resources/kxml/schemas/metadatacollection.xsd");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void load(KXmlParser parser) throws Exception {
        while (true) {
            switch (parser.next()) {
                case 2: {
                    Calendar cal;
                    if (parser.getName().equals("Description")) {
                        this.setDescription(parser.nextText());
                    }
                    if (parser.getName().equals("Name")) {
                        this.setName(parser.nextText());
                    }
                    if (parser.getName().equals("IsUserCollection")) {
                        this.setUserCollection(KBoolean.load(parser));
                    }
                    if (parser.getName().equals("IsIndexable")) {
                        this.setIndexable(KBoolean.load(parser));
                    }
                    if (parser.getName().equals("IsEditable")) {
                        this.setEditable(KBoolean.load(parser));
                    }
                    if (parser.getName().equals("CreationTime")) {
                        cal = Calendar.getInstance();
                        cal.setTime(KGCUBEResource.fromXMLDateAndTime(parser.nextText()));
                        this.setCreationTime(cal);
                    }
                    if (parser.getName().equals("Creator")) {
                        this.setCreator(parser.nextText());
                    }
                    if (parser.getName().equals("NumberOfMembers")) {
                        this.setNumberOfMembers(Integer.parseInt(parser.nextText()));
                    }
                    if (parser.getName().equals("LastUpdateTime")) {
                        cal = Calendar.getInstance();
                        cal.setTime(KGCUBEResource.fromXMLDateAndTime(parser.nextText()));
                        this.setLastUpdateTime(cal);
                    }
                    if (parser.getName().equals("PreviousUpdateTime")) {
                        cal = Calendar.getInstance();
                        cal.setTime(KGCUBEResource.fromXMLDateAndTime(parser.nextText()));
                        this.setPreviousUpdateTime(cal);
                    }
                    if (parser.getName().equals("LastModifier")) {
                        this.setLastModifier(parser.nextText());
                    }
                    if (parser.getName().equals("OID")) {
                        this.setOID(parser.nextText());
                    }
                    if (parser.getName().equals("RelatedCollection")) {
                        this.setRelCollection(KRelatedCollection.load(parser));
                    }
                    if (parser.getName().equals("MetadataFormat")) {
                        this.setMetaFormat(KMetadataFormat.load(parser));
                    }
                    if (!parser.getName().equals("GeneratedBy")) break;
                    this.setGenerateBy(KGeneratedBy.load(parser));
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("Profile")) break;
                    return;
                }
                case 1: {
                    throw new Exception("Parsing failed at Profile");
                }
            }
        }
    }

    @Override
    public void store(KXmlSerializer serializer) throws Exception {
        serializer.startTag(KGCUBEResource.NS, "Profile");
        if (this.getDescription() != null) {
            serializer.startTag(KGCUBEResource.NS, "Description").text(this.getDescription()).endTag(KGCUBEResource.NS, "Description");
        }
        if (this.getName() != null) {
            serializer.startTag(KGCUBEResource.NS, "Name").text(this.getName()).endTag(KGCUBEResource.NS, "Name");
        }
        serializer.startTag(KGCUBEResource.NS, "IsUserCollection");
        KBoolean.store(this.isUserCollection(), serializer);
        serializer.endTag(KGCUBEResource.NS, "IsUserCollection");
        serializer.startTag(KGCUBEResource.NS, "IsIndexable");
        KBoolean.store(this.isIndexable(), serializer);
        serializer.endTag(KGCUBEResource.NS, "IsIndexable");
        serializer.startTag(KGCUBEResource.NS, "IsEditable");
        KBoolean.store(this.isEditable(), serializer);
        serializer.endTag(KGCUBEResource.NS, "IsEditable");
        if (this.getCreationTime() != null) {
            serializer.startTag(KGCUBEResource.NS, "CreationTime").text(KGCUBEResource.toXMLDateAndTime(this.getCreationTime().getTime())).endTag(KGCUBEResource.NS, "CreationTime");
        }
        if (this.getCreator() != null) {
            serializer.startTag(KGCUBEResource.NS, "Creator").text(this.getCreator()).endTag(KGCUBEResource.NS, "Creator");
        }
        serializer.startTag(KGCUBEResource.NS, "NumberOfMembers").text(String.valueOf(this.getNumberOfMembers())).endTag(KGCUBEResource.NS, "NumberOfMembers");
        if (this.getLastUpdateTime() != null) {
            serializer.startTag(KGCUBEResource.NS, "LastUpdateTime").text(KGCUBEResource.toXMLDateAndTime(this.getLastUpdateTime().getTime())).endTag(KGCUBEResource.NS, "LastUpdateTime");
        }
        if (this.getPreviousUpdateTime() != null) {
            serializer.startTag(KGCUBEResource.NS, "PreviousUpdateTime").text(KGCUBEResource.toXMLDateAndTime(this.getPreviousUpdateTime().getTime())).endTag(KGCUBEResource.NS, "PreviousUpdateTime");
        }
        if (this.getLastModifier() != null) {
            serializer.startTag(KGCUBEResource.NS, "LastModifier").text(this.getLastModifier()).endTag(KGCUBEResource.NS, "LastModifier");
        }
        if (this.getOID() != null) {
            serializer.startTag(KGCUBEResource.NS, "OID").text(this.getOID()).endTag(KGCUBEResource.NS, "OID");
        }
        if (this.getRelCollection() != null) {
            KRelatedCollection.store(this.getRelCollection(), serializer);
        }
        if (this.getMetaFormat() != null) {
            KMetadataFormat.store(this.getMetaFormat(), serializer);
        }
        if (this.getGenerateBy() != null) {
            KGeneratedBy.store(this.getGenerateBy(), serializer);
        }
        serializer.endTag(KGCUBEResource.NS, "Profile");
    }

    static class KGeneratedBy {
        KGeneratedBy() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public static GCUBEMCollection.GeneratedBy load(KXmlParser parser) throws Exception {
            GCUBEMCollection.GeneratedBy e = new GCUBEMCollection.GeneratedBy();
            while (true) {
                switch (parser.next()) {
                    case 2: {
                        if (parser.getName().equals("CollectionID")) {
                            e.setCollectionID(parser.nextText());
                        }
                        if (!parser.getName().equals("SourceSchemaURI")) break;
                        e.setSourceSchemaURI(new URI(parser.nextText()));
                        break;
                    }
                    case 3: {
                        if (!parser.getName().equals("GeneratedBy")) break;
                        return e;
                    }
                    case 1: {
                        throw new Exception("Parsing failed at GeneratedBy");
                    }
                }
            }
        }

        public static void store(GCUBEMCollection.GeneratedBy col, KXmlSerializer serializer) throws Exception {
            if (col == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "GeneratedBy");
            if (col.getCollectionID() != null) {
                serializer.startTag(KGCUBEResource.NS, "CollectionID").text(col.getCollectionID()).endTag(KGCUBEResource.NS, "CollectionID");
            }
            if (col.getSourceSchemaURI() != null) {
                serializer.startTag(KGCUBEResource.NS, "SourceSchemaURI").text(col.getSourceSchemaURI().toURL().toString()).endTag(KGCUBEResource.NS, "SourceSchemaURI");
            }
            serializer.endTag(KGCUBEResource.NS, "GeneratedBy");
        }
    }

    static class KMetadataFormat {
        KMetadataFormat() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public static GCUBEMCollection.MetadataFormat load(KXmlParser parser) throws Exception {
            GCUBEMCollection.MetadataFormat e = new GCUBEMCollection.MetadataFormat();
            while (true) {
                switch (parser.next()) {
                    case 2: {
                        if (parser.getName().equals("Language")) {
                            e.setLanguage(parser.nextText());
                        }
                        if (parser.getName().equals("Name")) {
                            e.setName(parser.nextText());
                        }
                        if (!parser.getName().equals("SchemaURI")) break;
                        e.setSchemaURI(new URI(parser.nextText()));
                        break;
                    }
                    case 3: {
                        if (!parser.getName().equals("MetadataFormat")) break;
                        return e;
                    }
                    case 1: {
                        throw new Exception("Parsing failed at MetadataFormat");
                    }
                }
            }
        }

        public static void store(GCUBEMCollection.MetadataFormat col, KXmlSerializer serializer) throws Exception {
            if (col == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "MetadataFormat");
            if (col.getSchemaURI() != null) {
                serializer.startTag(KGCUBEResource.NS, "SchemaURI").text(col.getSchemaURI().toURL().toString()).endTag(KGCUBEResource.NS, "SchemaURI");
            }
            if (col.getLanguage() != null) {
                serializer.startTag(KGCUBEResource.NS, "Language").text(col.getLanguage()).endTag(KGCUBEResource.NS, "Language");
            }
            if (col.getName() != null) {
                serializer.startTag(KGCUBEResource.NS, "Name").text(col.getName()).endTag(KGCUBEResource.NS, "Name");
            }
            serializer.endTag(KGCUBEResource.NS, "MetadataFormat");
        }
    }

    static class KRelatedCollection {
        KRelatedCollection() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public static GCUBEMCollection.RelatedCollection load(KXmlParser parser) throws Exception {
            GCUBEMCollection.RelatedCollection e = new GCUBEMCollection.RelatedCollection();
            while (true) {
                switch (parser.next()) {
                    case 2: {
                        if (parser.getName().equals("CollectionID")) {
                            e.setCollectionID(parser.nextText());
                        }
                        if (!parser.getName().equals("SecondaryRole")) break;
                        e.setSecondaryRole(parser.nextText());
                        break;
                    }
                    case 3: {
                        if (!parser.getName().equals("RelatedCollection")) break;
                        return e;
                    }
                    case 1: {
                        throw new Exception("Parsing failed at RelatedCollection");
                    }
                }
            }
        }

        public static void store(GCUBEMCollection.RelatedCollection col, KXmlSerializer serializer) throws Exception {
            if (col == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "RelatedCollection");
            if (col.getCollectionID() != null) {
                serializer.startTag(KGCUBEResource.NS, "CollectionID").text(col.getCollectionID()).endTag(KGCUBEResource.NS, "CollectionID");
            }
            if (col.getSecondaryRole() != null) {
                serializer.startTag(KGCUBEResource.NS, "SecondaryRole").text(col.getSecondaryRole()).endTag(KGCUBEResource.NS, "SecondaryRole");
            }
            serializer.endTag(KGCUBEResource.NS, "RelatedCollection");
        }
    }
}

