/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.calls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.scope.GCUBEScopeManagerImpl;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.handlers.GCUBEServiceClientImpl;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class GCUBECall<QUERY extends ISQuery<?>> {
    protected static Map<Class<?>, GCUBEServiceClientImpl> clients = Collections.synchronizedMap(new HashMap());
    protected GCUBELog logger = new GCUBELog(this);
    private GCUBEScopeManager scopeManager;
    private GCUBESecurityManager securityManager;
    private QUERY query;
    private EndpointReferenceType epr;

    public GCUBECall(GCUBEScopeManager scopeManager, GCUBESecurityManager ... securityManager) throws Exception {
        this.scopeManager = scopeManager;
        if (securityManager != null && securityManager.length > 0) {
            this.securityManager = securityManager[0];
        }
        this.setQuery(this.getInitQuery());
        if (!clients.containsKey(this.getClass())) {
            clients.put(this.getClass(), new GCUBEServiceClientImpl(){

                @Override
                public GCUBEScope getScope() {
                    return GCUBECall.this.getScopeManager().getScope();
                }
            });
        }
    }

    public GCUBECall(final GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
        this(new GCUBEScopeManagerImpl(){

            @Override
            public GCUBEScope getScope() {
                return scope;
            }
        }, securityManager);
    }

    public GCUBECall(GCUBEServiceContext ctxt) throws Exception {
        this(ctxt, ctxt);
    }

    public void setLogger(GCUBELog logger) {
        this.logger = logger;
    }

    public GCUBELog getLogger() {
        return this.logger;
    }

    protected abstract String getPortTypeName();

    protected abstract String getServiceName();

    protected abstract String getServiceClass();

    public GCUBESecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(GCUBESecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public GCUBEScopeManager getScopeManager() {
        return this.scopeManager;
    }

    public void setScopeManager(GCUBEScopeManager scopeManager) {
        this.scopeManager = scopeManager;
    }

    public void setQuery(QUERY query) {
        this.query = query;
    }

    public QUERY getQuery() {
        return this.query;
    }

    protected abstract QUERY getInitQuery() throws Exception;

    public void setEndpointReference(EndpointReferenceType epr) {
        this.epr = epr;
    }

    public EndpointReferenceType getEndpointReference() {
        return this.epr;
    }

    protected GCUBERIQuery getRIQuery() throws Exception {
        GCUBERIQuery q = GHNContext.getImplementation(ISClient.class).getQuery(GCUBERIQuery.class);
        q.addAtomicConditions(new AtomicCondition("//ServiceName", this.getServiceName()), new AtomicCondition("//ServiceClass", this.getServiceClass()));
        return q;
    }

    protected List<EndpointReferenceType> findPortType(GCUBERIQuery query, String portType) throws Exception {
        ISClient client = GHNContext.getImplementation(ISClient.class);
        ArrayList<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
        for (GCUBERunningInstance instance : client.execute(query, this.getScopeManager().getScope())) {
            if (instance.getAccessPoint().getEndpoint(portType) == null) continue;
            eprs.add(instance.getAccessPoint().getEndpoint(portType));
        }
        return eprs;
    }

    public static class ResultHolder<RESULT> {
        public RESULT value;
    }
}

