/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.reflections.vfs.SystemDir;
import org.reflections.vfs.Vfs;

public class SystemFile
implements Vfs.File {
    private final SystemDir dir;
    private final File file;

    public SystemFile(SystemDir dir, File file) {
        this.dir = dir;
        this.file = file;
    }

    public String getFullPath() {
        return this.file.getPath();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getRelativePath() {
        if (this.file.getPath().startsWith(this.dir.getPath())) {
            return this.file.getPath().substring(this.dir.getPath().length() + 1).replace('\\', '/');
        }
        return null;
    }

    public InputStream openInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.file.toString();
    }
}

