/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.CoordSysEvaluator;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.JoinArray;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class CFpointObs
extends TableConfigurerImpl {
    @Override
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.startsWith("CF")) continue;
            return true;
        }
        return false;
    }

    @Override
    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        CF.FeatureType ftype = CF.FeatureType.getFeatureTypeFromGlobalAttribute(ds);
        if (ftype == null) {
            ftype = CF.FeatureType.point;
        }
        if (!this.checkCoordinates(ds, errlog)) {
            return null;
        }
        switch (ftype) {
            case point: {
                return this.getPointConfig(ds, errlog);
            }
            case timeSeries: {
                return this.getStationConfig(ds, errlog);
            }
            case trajectory: {
                return this.getTrajectoryConfig(ds, errlog);
            }
            case profile: {
                return this.getProfileConfig(ds, errlog);
            }
            case timeSeriesProfile: {
                return this.getTimeSeriesProfileConfig(ds, errlog);
            }
            case trajectoryProfile: {
                return this.getSectionConfig(ds, errlog);
            }
        }
        return null;
    }

    private boolean checkCoordinates(NetcdfDataset ds, Formatter errlog) {
        List<Dimension> dimLon;
        CoordinateAxis lon;
        CoordinateAxis lat;
        boolean ok = true;
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            errlog.format("CFpointObs cant find a Time coordinate %n", new Object[0]);
            ok = false;
        }
        if ((lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat)) == null) {
            errlog.format("CFpointObs cant find a Latitude coordinate %n", new Object[0]);
            ok = false;
        }
        if ((lon = CoordSysEvaluator.findCoordByType(ds, AxisType.Lon)) == null) {
            errlog.format("CFpointObs cant find a Longitude coordinate %n", new Object[0]);
            ok = false;
        }
        if (!ok) {
            return false;
        }
        List<Dimension> dimLat = lat.getDimensions();
        if (!((Object)dimLat).equals(dimLon = lon.getDimensions())) {
            errlog.format("Lat and Lon coordinate dimensions must match lat=%s lon=%s %n", lat.getNameAndDimensions(), lon.getNameAndDimensions());
            ok = false;
        }
        return ok;
    }

    private TableConfig getPointConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time.getRank() != 1) {
            errlog.format("CFpointObs type=point: coord time must have rank 1, coord var= %s %n", time.getNameAndDimensions());
            return null;
        }
        Dimension obsDim = time.getDimension(0);
        TableConfig obsTable = this.makeSingle(ds, obsDim, errlog);
        obsTable.featureType = FeatureType.POINT;
        return obsTable;
    }

    private TableConfig getStationConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        EncodingInfo info = this.identifyEncodingStation(ds, CF.FeatureType.timeSeries, errlog);
        if (info == null) {
            return null;
        }
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        Variable parentId = this.identifyParent(ds, CF.FeatureType.timeSeries);
        Dimension obsDim = info.childDim;
        TableConfig stnTable = this.makeStationTable(ds, FeatureType.STATION, info, errlog);
        if (stnTable == null) {
            return null;
        }
        TableConfig obsTable = null;
        switch (info.encoding) {
            case single: {
                obsTable = this.makeSingle(ds, obsDim, errlog);
                break;
            }
            case multidim: {
                obsTable = this.makeMultidimInner(ds, stnTable, obsDim, errlog);
                if (time.getRank() != 1) break;
                obsTable.addJoin(new JoinArray(time, JoinArray.Type.raw, 0));
                obsTable.time = time.getShortName();
                break;
            }
            case raggedContiguous: {
                obsTable = this.makeRaggedContiguous(ds, info.parentDim, info.childDim, errlog);
                break;
            }
            case raggedIndex: {
                obsTable = this.makeRaggedIndex(ds, info.parentDim, info.childDim, errlog);
                break;
            }
            case flat: {
                obsTable = this.makeStructTable(ds, FeatureType.STATION, new EncodingInfo(Encoding.flat, obsDim), errlog);
                obsTable.parentIndex = parentId == null ? null : parentId.getName();
                obsTable.stnId = this.findNameVariableWithStandardNameAndDimension(ds, "station_id", obsDim, errlog);
                obsTable.stnDesc = this.findNameVariableWithStandardNameAndDimension(ds, "station_desc", obsDim, errlog);
                obsTable.stnWmoId = this.findNameVariableWithStandardNameAndDimension(ds, "station_WMO_id", obsDim, errlog);
                obsTable.stnAlt = this.findNameVariableWithStandardNameAndDimension(ds, "surface_altitude", obsDim, errlog);
            }
        }
        if (obsTable == null) {
            return null;
        }
        stnTable.addChild(obsTable);
        return stnTable;
    }

    private TableConfig getTrajectoryConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        EncodingInfo info = this.identifyEncodingTraj(ds, CF.FeatureType.trajectory, errlog);
        if (info == null) {
            return null;
        }
        TableConfig parentTable = this.makeStructTable(ds, FeatureType.TRAJECTORY, info, errlog);
        if (parentTable == null) {
            return null;
        }
        parentTable.feature_id = this.identifyParentId(ds, CF.FeatureType.trajectory);
        if (parentTable.feature_id == null) {
            errlog.format("getTrajectoryConfig cant find a trajectoy id %n", new Object[0]);
        }
        TableConfig obsConfig = null;
        switch (info.encoding) {
            case single: {
                obsConfig = this.makeSingle(ds, info.childDim, errlog);
                break;
            }
            case multidim: {
                obsConfig = this.makeMultidimInner(ds, parentTable, info.childDim, errlog);
                break;
            }
            case raggedContiguous: {
                obsConfig = this.makeRaggedContiguous(ds, info.parentDim, info.childDim, errlog);
                break;
            }
            case raggedIndex: {
                obsConfig = this.makeRaggedIndex(ds, info.parentDim, info.childDim, errlog);
                break;
            }
            case flat: {
                throw new UnsupportedOperationException("CFpointObs: trajectory flat encoding");
            }
        }
        if (obsConfig == null) {
            return null;
        }
        parentTable.addChild(obsConfig);
        return parentTable;
    }

    private TableConfig getProfileConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        CoordinateAxis z;
        EncodingInfo info = this.identifyEncodingProfile(ds, CF.FeatureType.profile, errlog);
        if (info == null) {
            return null;
        }
        TableConfig parentTable = this.makeStructTable(ds, FeatureType.PROFILE, info, errlog);
        if (parentTable == null) {
            return null;
        }
        parentTable.feature_id = this.identifyParentId(ds, CF.FeatureType.profile);
        if (parentTable.feature_id == null) {
            errlog.format("getProfileConfig cant find a profile id %n", new Object[0]);
        }
        if ((z = CoordSysEvaluator.findCoordByType(ds, AxisType.Height)) == null) {
            errlog.format("getProfileConfig cant find a Height coordinate %n", new Object[0]);
            return null;
        }
        TableConfig obsTable = null;
        switch (info.encoding) {
            case single: {
                obsTable = this.makeSingle(ds, info.childDim, errlog);
                break;
            }
            case multidim: {
                obsTable = this.makeMultidimInner(ds, parentTable, info.childDim, errlog);
                if (z.getRank() != 1) break;
                obsTable.addJoin(new JoinArray(z, JoinArray.Type.raw, 0));
                break;
            }
            case raggedContiguous: {
                obsTable = this.makeRaggedContiguous(ds, info.parentDim, info.childDim, errlog);
                break;
            }
            case raggedIndex: {
                obsTable = this.makeRaggedIndex(ds, info.parentDim, info.childDim, errlog);
                break;
            }
            case flat: {
                throw new UnsupportedOperationException("CFpointObs: profile flat encoding");
            }
        }
        if (obsTable == null) {
            return null;
        }
        parentTable.addChild(obsTable);
        return parentTable;
    }

    private TableConfig getTimeSeriesProfileConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        EncodingInfo info = this.identifyEncodingTimeSeriesProfile(ds, CF.FeatureType.timeSeriesProfile, errlog);
        if (info == null) {
            return null;
        }
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time.getRank() == 0) {
            errlog.format("timeSeriesProfile cannot have a scalar time coordinate%n", new Object[0]);
            return null;
        }
        CoordinateAxis z = this.findZAxisNotStationAlt(ds);
        if (z == null) {
            errlog.format("timeSeriesProfile must have a z coordinate%n", new Object[0]);
            return null;
        }
        if (z.getRank() == 0) {
            errlog.format("timeSeriesProfile cannot have a scalar z coordinate%n", new Object[0]);
            return null;
        }
        TableConfig stationTable = this.makeStationTable(ds, FeatureType.STATION_PROFILE, info, errlog);
        if (stationTable == null) {
            return null;
        }
        switch (info.encoding) {
            case single: {
                TableConfig profileTable;
                assert (time.getRank() >= 1 && time.getRank() <= 2) : "time must be rank 1 or 2";
                assert (z.getRank() >= 1 && z.getRank() <= 2) : "z must be rank 1 or 2";
                if (time.getRank() == 2) {
                    if (z.getRank() == 2) {
                        assert (((Object)time.getDimensions()).equals(z.getDimensions())) : "rank-2 time and z dimensions must be the same";
                    } else assert (time.getDimension(1).equals(z.getDimension(0))) : "rank-2 time must have z inner dimension";
                } else if (z.getRank() == 2) {
                    assert (z.getDimension(0).equals(time.getDimension(0))) : "rank-2 z must have time outer dimension";
                } else assert (!time.getDimension(0).equals(z.getDimension(0))) : "time and z dimensions must be different";
                if ((profileTable = this.makeStructTable(ds, FeatureType.PROFILE, new EncodingInfo(Encoding.multidim, info.childDim), errlog)) == null) {
                    return null;
                }
                if (time.getRank() == 1) {
                    profileTable.addJoin(new JoinArray(time, JoinArray.Type.raw, 0));
                }
                stationTable.addChild(profileTable);
                TableConfig zTable = this.makeMultidimInner(ds, profileTable, info.grandChildDim, errlog);
                if (z.getRank() == 1) {
                    zTable.addJoin(new JoinArray(z, JoinArray.Type.raw, 0));
                }
                profileTable.addChild(zTable);
                break;
            }
            case multidim: {
                TableConfig profileTable;
                assert (time.getRank() >= 2 && time.getRank() <= 3) : "time must be rank 2 or 3";
                assert (z.getRank() == 1 || z.getRank() == 3) : "z must be rank 1 or 3";
                if (time.getRank() == 3) {
                    if (z.getRank() == 3) {
                        assert (((Object)time.getDimensions()).equals(z.getDimensions())) : "rank-3 time and z dimensions must be the same";
                    } else assert (time.getDimension(2).equals(z.getDimension(0))) : "rank-3 time must have z inner dimension";
                } else if (z.getRank() == 3) {
                    assert (z.getDimension(1).equals(time.getDimension(1))) : "rank-2 time must have time inner dimension";
                } else {
                    assert (!time.getDimension(0).equals(z.getDimension(0))) : "time and z dimensions must be different";
                    assert (!time.getDimension(1).equals(z.getDimension(0))) : "time and z dimensions must be different";
                }
                if ((profileTable = this.makeMultidimInner(ds, stationTable, info.childDim, errlog)) == null) {
                    return null;
                }
                stationTable.addChild(profileTable);
                TableConfig zTable = this.makeMultidimInner3D(ds, stationTable, profileTable, info.grandChildDim, errlog);
                if (z.getRank() == 1) {
                    zTable.addJoin(new JoinArray(z, JoinArray.Type.raw, 0));
                }
                profileTable.addChild(zTable);
                break;
            }
            case raggedIndex: {
                Variable stationIndex = Evaluator.getVariableWithAttributeValue(ds, "CF:ragged_parent_index", info.parentDim.getName());
                if (stationIndex == null) {
                    errlog.format("timeSeriesProfile stationIndex: must have a ragged_parentIndex variable with profile dimension%n", new Object[0]);
                    return null;
                }
                if (stationIndex.getRank() != 1) {
                    errlog.format("timeSeriesProfile stationIndex: %s variable must be rank 1%n", stationIndex.getName());
                    return null;
                }
                Variable ragged_rowSize = Evaluator.getVariableWithAttributeValue(ds, "CF:ragged_row_count", info.grandChildDim.getName());
                if (ragged_rowSize == null) {
                    errlog.format("timeSeriesProfile numObs: must have a ragged_rowSize variable with profile dimension %s%n", info.childDim);
                    return null;
                }
                if (ragged_rowSize.getRank() != 1) {
                    errlog.format("timeSeriesProfile numObs: %s variable for observations must be rank 1%n", ragged_rowSize.getName());
                    return null;
                }
                if (info.childDim.equals(info.grandChildDim)) {
                    errlog.format("timeSeriesProfile profile dimension %s cannot be obs dimension %s%n", info.childDim, info.grandChildDim);
                    return null;
                }
                TableConfig profileTable = this.makeRaggedIndex(ds, info.parentDim, info.childDim, errlog);
                stationTable.addChild(profileTable);
                TableConfig zTable = this.makeRaggedContiguous(ds, info.childDim, info.grandChildDim, errlog);
                profileTable.addChild(zTable);
                break;
            }
            case raggedContiguous: {
                throw new UnsupportedOperationException("CFpointObs: profile raggedContiguous encoding");
            }
        }
        return stationTable;
    }

    private TableConfig getSectionConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        CoordinateAxis z;
        EncodingInfo info = this.identifyEncodingSection(ds, CF.FeatureType.trajectoryProfile, errlog);
        if (info == null) {
            return null;
        }
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time.getRank() == 0) {
            errlog.format("section cannot have a scalar time coordinate%n", new Object[0]);
            return null;
        }
        TableConfig parentTable = this.makeStructTable(ds, FeatureType.SECTION, info, errlog);
        if (parentTable == null) {
            return null;
        }
        parentTable.feature_id = this.identifyParentId(ds, CF.FeatureType.trajectoryProfile);
        if (parentTable.feature_id == null) {
            errlog.format("getSectionConfig cant find a section id %n", new Object[0]);
        }
        if ((z = this.findZAxisNotStationAlt(ds)) == null) {
            errlog.format("section must have a z coordinate%n", new Object[0]);
            return null;
        }
        if (z.getRank() == 0) {
            errlog.format("section cannot have a scalar z coordinate%n", new Object[0]);
            return null;
        }
        switch (info.encoding) {
            case single: {
                TableConfig profileTable;
                assert (time.getRank() >= 1 && time.getRank() <= 2) : "time must be rank 1 or 2";
                assert (z.getRank() >= 1 && z.getRank() <= 2) : "z must be rank 1 or 2";
                if (time.getRank() == 2) {
                    if (z.getRank() == 2) {
                        assert (((Object)time.getDimensions()).equals(z.getDimensions())) : "rank-2 time and z dimensions must be the same";
                    } else assert (time.getDimension(1).equals(z.getDimension(0))) : "rank-2 time must have z inner dimension";
                } else if (z.getRank() == 2) {
                    assert (z.getDimension(0).equals(time.getDimension(0))) : "rank-2 z must have time outer dimension";
                } else assert (!time.getDimension(0).equals(z.getDimension(0))) : "time and z dimensions must be different";
                if ((profileTable = this.makeStructTable(ds, FeatureType.PROFILE, new EncodingInfo(Encoding.multidim, info.childDim), errlog)) == null) {
                    return null;
                }
                if (time.getRank() == 1) {
                    profileTable.addJoin(new JoinArray(time, JoinArray.Type.raw, 0));
                }
                parentTable.addChild(profileTable);
                TableConfig zTable = this.makeMultidimInner(ds, profileTable, info.grandChildDim, errlog);
                if (z.getRank() == 1) {
                    zTable.addJoin(new JoinArray(z, JoinArray.Type.raw, 0));
                }
                profileTable.addChild(zTable);
                break;
            }
            case multidim: {
                TableConfig profileTable;
                assert (time.getRank() >= 2 && time.getRank() <= 3) : "time must be rank 2 or 3";
                assert (z.getRank() == 1 || z.getRank() == 3) : "z must be rank 1 or 3";
                if (time.getRank() == 3) {
                    if (z.getRank() == 3) {
                        assert (((Object)time.getDimensions()).equals(z.getDimensions())) : "rank-3 time and z dimensions must be the same";
                    } else assert (time.getDimension(2).equals(z.getDimension(0))) : "rank-3 time must have z inner dimension";
                } else if (z.getRank() == 3) {
                    assert (z.getDimension(1).equals(time.getDimension(1))) : "rank-2 time must have time inner dimension";
                } else {
                    assert (!time.getDimension(0).equals(z.getDimension(0))) : "time and z dimensions must be different";
                    assert (!time.getDimension(1).equals(z.getDimension(0))) : "time and z dimensions must be different";
                }
                if ((profileTable = this.makeMultidimInner(ds, parentTable, info.childDim, errlog)) == null) {
                    return null;
                }
                profileTable.feature_id = this.identifyParentId(ds, CF.FeatureType.profile);
                parentTable.addChild(profileTable);
                TableConfig zTable = this.makeMultidimInner3D(ds, parentTable, profileTable, info.grandChildDim, errlog);
                if (z.getRank() == 1) {
                    zTable.addJoin(new JoinArray(z, JoinArray.Type.raw, 0));
                }
                profileTable.addChild(zTable);
                break;
            }
            case raggedIndex: {
                Variable sectionIndex = Evaluator.getVariableWithAttributeValue(ds, "CF:ragged_parent_index", info.parentDim.getName());
                if (sectionIndex == null) {
                    errlog.format("section sectionIndex: must have a ragged_parentIndex variable with profile dimension%n", new Object[0]);
                    return null;
                }
                if (sectionIndex.getRank() != 1) {
                    errlog.format("section sectionIndex: %s variable must be rank 1%n", sectionIndex.getName());
                    return null;
                }
                Variable numObs = Evaluator.getVariableWithAttributeValue(ds, "CF:ragged_row_count", info.grandChildDim.getName());
                if (numObs == null) {
                    errlog.format("section numObs: must have a ragged_rowSize variable with profile dimension %s%n", info.childDim);
                    return null;
                }
                if (numObs.getRank() != 1) {
                    errlog.format("section numObs: %s variable for observations must be rank 1%n", numObs.getName());
                    return null;
                }
                if (info.childDim.equals(info.grandChildDim)) {
                    errlog.format("section profile dimension %s cannot be obs dimension %s%n", info.childDim, info.grandChildDim);
                    return null;
                }
                TableConfig profileTable = this.makeRaggedIndex(ds, info.parentDim, info.childDim, errlog);
                parentTable.addChild(profileTable);
                TableConfig zTable = this.makeRaggedContiguous(ds, info.childDim, info.grandChildDim, errlog);
                profileTable.addChild(zTable);
                break;
            }
            case raggedContiguous: {
                throw new UnsupportedOperationException("CFpointObs: section raggedContiguous encoding%n");
            }
        }
        return parentTable;
    }

    private EncodingInfo identifyEncoding(NetcdfDataset ds, CF.FeatureType ftype, Formatter errlog) {
        Variable ragged_rowSize = Evaluator.getVariableWithAttribute(ds, "CF:ragged_row_count");
        if (ragged_rowSize != null) {
            if (ftype == CF.FeatureType.trajectoryProfile) {
                Variable parentId = this.identifyParent(ds, ftype);
                if (parentId == null) {
                    errlog.format("Section ragged must have section_id variable%n", new Object[0]);
                    return null;
                }
                return new EncodingInfo(Encoding.raggedContiguous, parentId);
            }
            return new EncodingInfo(Encoding.raggedContiguous, ragged_rowSize);
        }
        Variable ragged_parentIndex = Evaluator.getVariableWithAttribute(ds, "CF:ragged_parent_index");
        if (ragged_parentIndex != null) {
            Variable ragged_parentId = this.identifyParent(ds, ftype);
            return new EncodingInfo(Encoding.raggedIndex, ragged_parentId);
        }
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        if (lat == null) {
            errlog.format("Must have a Latitude coordinate%n", new Object[0]);
            return null;
        }
        switch (ftype) {
            case point: {
                return new EncodingInfo(Encoding.multidim, (Dimension)null);
            }
            case timeSeries: 
            case profile: 
            case timeSeriesProfile: {
                if (lat.getRank() == 0) {
                    return new EncodingInfo(Encoding.single, (Dimension)null);
                }
                if (lat.getRank() == 1) {
                    return new EncodingInfo(Encoding.multidim, lat);
                }
                errlog.format("CFpointObs %s Must have Lat/Lon coordinates of rank 0 or 1%n", new Object[]{ftype});
                return null;
            }
            case trajectory: 
            case trajectoryProfile: {
                if (lat.getRank() == 1) {
                    return new EncodingInfo(Encoding.single, (Dimension)null);
                }
                if (lat.getRank() == 2) {
                    return new EncodingInfo(Encoding.multidim, lat);
                }
                errlog.format("CFpointObs %s Must have Lat/Lon coordinates of rank 1 or 2%n", new Object[]{ftype});
                return null;
            }
        }
        return null;
    }

    private EncodingInfo identifyEncodingStation(NetcdfDataset ds, CF.FeatureType ftype, Formatter errlog) {
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            errlog.format("Must have a Time coordinate%n", new Object[0]);
            return null;
        }
        Dimension obsDim = null;
        if (time.getRank() > 0) {
            obsDim = time.getDimension(time.getRank() - 1);
        } else if (time.getParentStructure() != null) {
            Structure parent = time.getParentStructure();
            obsDim = parent.getDimension(parent.getRank() - 1);
        }
        if (obsDim == null) {
            errlog.format("Must have a non-scalar Time coordinate%n", new Object[0]);
            return null;
        }
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        if (lat == null) {
            errlog.format("Must have a Latitude coordinate%n", new Object[0]);
            return null;
        }
        if (lat.getRank() == 0) {
            return new EncodingInfo(Encoding.single, null, obsDim);
        }
        Dimension stnDim = lat.getDimension(0);
        if (obsDim == stnDim) {
            return new EncodingInfo(Encoding.flat, null, obsDim);
        }
        Variable ragged_rowSize = Evaluator.getVariableWithAttributeValue(ds, "CF:ragged_row_count", obsDim.getName());
        if (ragged_rowSize != null) {
            return new EncodingInfo(Encoding.raggedContiguous, stnDim, obsDim);
        }
        Variable ragged_parentIndex = Evaluator.getVariableWithAttributeValue(ds, "CF:ragged_parent_index", stnDim.getName());
        if (ragged_parentIndex != null) {
            return new EncodingInfo(Encoding.raggedIndex, stnDim, obsDim);
        }
        if (lat.getRank() == 1) {
            return new EncodingInfo(Encoding.multidim, stnDim, obsDim);
        }
        errlog.format("CFpointObs %s Must have Lat/Lon coordinates of rank 0 or 1%n", new Object[]{ftype});
        return null;
    }

    private EncodingInfo identifyEncodingTraj(NetcdfDataset ds, CF.FeatureType ftype, Formatter errlog) {
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            errlog.format("Must have a Time coordinate%n", new Object[0]);
            return null;
        }
        Dimension obsDim = null;
        if (time.getRank() > 0) {
            obsDim = time.getDimension(time.getRank() - 1);
        } else if (time.getParentStructure() != null) {
            Structure parent = time.getParentStructure();
            obsDim = parent.getDimension(parent.getRank() - 1);
        }
        if (obsDim == null) {
            errlog.format("Must have a non-scalar Time coordinate%n", new Object[0]);
            return null;
        }
        Dimension parentDim = null;
        if (time.getRank() > 1) {
            parentDim = time.getDimension(0);
            return new EncodingInfo(Encoding.multidim, parentDim, obsDim);
        }
        String dimName = Evaluator.getVariableAttributeValue(ds, "CF:ragged_parent_index");
        if (dimName != null) {
            parentDim = ds.findDimension(dimName);
            if (parentDim != null) {
                return new EncodingInfo(Encoding.raggedIndex, parentDim, obsDim);
            }
            errlog.format("CFpointObs %s ragged_parent_index must name parent dimension%n", new Object[]{ftype});
            return null;
        }
        Variable ragged_rowSize = Evaluator.getVariableWithAttributeValue(ds, "CF:ragged_row_count", obsDim.getName());
        if (ragged_rowSize != null) {
            parentDim = ragged_rowSize.getDimension(0);
            return new EncodingInfo(Encoding.raggedContiguous, parentDim, obsDim);
        }
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        if (lat == null) {
            errlog.format("Must have a Lat coordinate%n", new Object[0]);
            return null;
        }
        if (lat.getRank() > 0) {
            for (Dimension d : lat.getDimensions()) {
                if (d.equals(obsDim)) continue;
                return new EncodingInfo(Encoding.multidim, d, obsDim);
            }
        }
        return new EncodingInfo(Encoding.single, null, obsDim);
    }

    private EncodingInfo identifyEncodingProfile(NetcdfDataset ds, CF.FeatureType ftype, Formatter errlog) {
        CoordinateAxis z = CoordSysEvaluator.findCoordByType(ds, AxisType.Height);
        if (z == null) {
            errlog.format("Must have a Height coordinate%n", new Object[0]);
            return null;
        }
        Dimension obsDim = null;
        if (z.getRank() > 0) {
            obsDim = z.getDimension(z.getRank() - 1);
        } else if (z.getParentStructure() != null) {
            Structure parent = z.getParentStructure();
            obsDim = parent.getDimension(parent.getRank() - 1);
        }
        if (obsDim == null) {
            errlog.format("Must have a non-scalar Height coordinate%n", new Object[0]);
            return null;
        }
        Dimension parentDim = null;
        if (z.getRank() > 1) {
            parentDim = z.getDimension(0);
            return new EncodingInfo(Encoding.multidim, parentDim, obsDim);
        }
        String dimName = Evaluator.getVariableAttributeValue(ds, "CF:ragged_parent_index");
        if (dimName != null) {
            parentDim = ds.findDimension(dimName);
            if (parentDim != null) {
                return new EncodingInfo(Encoding.raggedIndex, parentDim, obsDim);
            }
            errlog.format("CFpointObs %s ragged_parent_index must name parent dimension%n", new Object[]{ftype});
            return null;
        }
        Variable ragged_rowSize = Evaluator.getVariableWithAttributeValue(ds, "CF:ragged_row_count", obsDim.getName());
        if (ragged_rowSize != null) {
            parentDim = ragged_rowSize.getDimension(0);
            return new EncodingInfo(Encoding.raggedContiguous, parentDim, obsDim);
        }
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            errlog.format("Must have a Time coordinate%n", new Object[0]);
            return null;
        }
        if (time.getRank() == 0 || time.getDimension(0) == obsDim) {
            return new EncodingInfo(Encoding.single, null, obsDim);
        }
        parentDim = time.getDimension(0);
        return new EncodingInfo(Encoding.multidim, parentDim, obsDim);
    }

    private EncodingInfo identifyEncodingSection(NetcdfDataset ds, CF.FeatureType ftype, Formatter errlog) {
        CoordinateAxis z = CoordSysEvaluator.findCoordByType(ds, AxisType.Height);
        if (z == null) {
            errlog.format("Must have a Height coordinate%n", new Object[0]);
            return null;
        }
        Dimension obsDim = null;
        if (z.getRank() > 0) {
            obsDim = z.getDimension(z.getRank() - 1);
        } else if (z.getParentStructure() != null) {
            Structure parent = z.getParentStructure();
            obsDim = parent.getDimension(parent.getRank() - 1);
        }
        if (obsDim == null) {
            errlog.format("Must have a non-scalar Height coordinate%n", new Object[0]);
            return null;
        }
        Dimension trajDim = null;
        Dimension profileDim = null;
        if (z.getRank() > 2) {
            trajDim = z.getDimension(0);
            profileDim = z.getDimension(1);
            return new EncodingInfo(Encoding.multidim, trajDim, profileDim, obsDim);
        }
        String dimName = Evaluator.getVariableAttributeValue(ds, "CF:ragged_parent_index");
        if (dimName != null) {
            trajDim = ds.findDimension(dimName);
            if (trajDim != null) {
                Variable ragged_rowSize = Evaluator.getVariableWithAttributeValue(ds, "CF:ragged_row_count", obsDim.getName());
                if (ragged_rowSize != null) {
                    profileDim = ragged_rowSize.getDimension(0);
                    return new EncodingInfo(Encoding.raggedIndex, trajDim, profileDim, obsDim);
                }
                errlog.format("CFpointObs %s ragged_row_count must name obs dimension%n", new Object[]{ftype});
                return null;
            }
            errlog.format("CFpointObs %s ragged_parent_index must name station dimension%n", new Object[]{ftype});
            return null;
        }
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        if (lat == null) {
            errlog.format("Must have a Lat coordinate%n", new Object[0]);
            return null;
        }
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            errlog.format("Must have a Time coordinate%n", new Object[0]);
            return null;
        }
        if (lat.getRank() == 0) {
            errlog.format("CFpointObs %s may not have scalar lat/lon%n", new Object[]{ftype});
            return null;
        }
        if (time.getRank() > 2) {
            trajDim = time.getDimension(0);
            profileDim = time.getDimension(1);
            return new EncodingInfo(Encoding.multidim, trajDim, profileDim, obsDim);
        }
        if (lat.getRank() == 1) {
            profileDim = lat.getDimension(0);
            return new EncodingInfo(Encoding.single, null, profileDim, obsDim);
        }
        if (lat.getRank() == 2) {
            trajDim = lat.getDimension(0);
            profileDim = lat.getDimension(0);
            return new EncodingInfo(Encoding.multidim, trajDim, profileDim, obsDim);
        }
        errlog.format("CFpointObs %s unrecognized form%n", new Object[]{ftype});
        return null;
    }

    private EncodingInfo identifyEncodingTimeSeriesProfile(NetcdfDataset ds, CF.FeatureType ftype, Formatter errlog) {
        CoordinateAxis z = this.findZAxisNotStationAlt(ds);
        if (z == null) {
            errlog.format("timeSeriesProfile must have a z coordinate, not the station altitude%n", new Object[0]);
            return null;
        }
        if (z.getRank() == 0) {
            errlog.format("timeSeriesProfile cannot have a scalar z coordinate%n", new Object[0]);
            return null;
        }
        Dimension obsDim = z.getDimension(z.getRank() - 1);
        Dimension stnDim = null;
        Dimension profileDim = null;
        if (z.getRank() > 2) {
            stnDim = z.getDimension(0);
            profileDim = z.getDimension(1);
            return new EncodingInfo(Encoding.multidim, stnDim, profileDim, obsDim);
        }
        String dimName = Evaluator.getVariableAttributeValue(ds, "CF:ragged_parent_index");
        if (dimName != null) {
            stnDim = ds.findDimension(dimName);
            if (stnDim != null) {
                Variable ragged_rowSize = Evaluator.getVariableWithAttributeValue(ds, "CF:ragged_row_count", obsDim.getName());
                if (ragged_rowSize != null) {
                    profileDim = ragged_rowSize.getDimension(0);
                    return new EncodingInfo(Encoding.raggedIndex, stnDim, profileDim, obsDim);
                }
                errlog.format("CFpointObs %s ragged_row_count must name obs dimension%n", new Object[]{ftype});
                return null;
            }
            errlog.format("CFpointObs %s ragged_parent_index must name station dimension%n", new Object[]{ftype});
            return null;
        }
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        if (lat == null) {
            errlog.format("Must have a Lat coordinate%n", new Object[0]);
            return null;
        }
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            errlog.format("Must have a Time coordinate%n", new Object[0]);
            return null;
        }
        if (lat.getRank() == 0) {
            profileDim = time.getDimension(0);
            return new EncodingInfo(Encoding.single, null, profileDim, obsDim);
        }
        if (time.getRank() == 1 || time.getRank() == 2 && time.getDimension(1) == obsDim) {
            profileDim = time.getDimension(0);
            return new EncodingInfo(Encoding.flat, null, profileDim, obsDim);
        }
        if (time.getRank() > 1) {
            stnDim = time.getDimension(0);
            profileDim = time.getDimension(1);
            return new EncodingInfo(Encoding.multidim, stnDim, profileDim, obsDim);
        }
        errlog.format("CFpointObs %s unrecognized form%n", new Object[]{ftype});
        return null;
    }

    private String identifyParentId(NetcdfDataset ds, CF.FeatureType ftype) {
        Variable v = this.identifyParent(ds, ftype);
        return v == null ? null : v.getShortName();
    }

    private Variable identifyParent(NetcdfDataset ds, CF.FeatureType ftype) {
        switch (ftype) {
            case timeSeries: 
            case timeSeriesProfile: {
                return Evaluator.getVariableWithAttributeValue(ds, "standard_name", "station_id");
            }
            case trajectory: {
                return Evaluator.getVariableWithAttributeValue(ds, "standard_name", "trajectory_id");
            }
            case profile: {
                return Evaluator.getVariableWithAttributeValue(ds, "standard_name", "profile_id");
            }
            case trajectoryProfile: {
                return Evaluator.getVariableWithAttributeValue(ds, "standard_name", "trajectory_id");
            }
        }
        return null;
    }

    private TableConfig makeStationTable(NetcdfDataset ds, FeatureType ftype, EncodingInfo info, Formatter errlog) throws IOException {
        CoordinateAxis alt;
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        CoordinateAxis lon = CoordSysEvaluator.findCoordByType(ds, AxisType.Lon);
        Table.Type stationTableType = Table.Type.Structure;
        if (info.encoding == Encoding.single) {
            stationTableType = Table.Type.Top;
        }
        if (info.encoding == Encoding.flat) {
            stationTableType = Table.Type.Construct;
        }
        Dimension stationDim = info.encoding == Encoding.flat ? info.childDim : info.parentDim;
        String name = stationDim == null ? " single" : stationDim.getName();
        TableConfig stnTable = new TableConfig(stationTableType, name);
        stnTable.featureType = ftype;
        stnTable.stnId = this.findNameVariableWithStandardNameAndDimension(ds, "station_id", stationDim, errlog);
        stnTable.stnDesc = this.findNameVariableWithStandardNameAndDimension(ds, "station_desc", stationDim, errlog);
        stnTable.stnWmoId = this.findNameVariableWithStandardNameAndDimension(ds, "station_WMO_id", stationDim, errlog);
        stnTable.stnAlt = this.findNameVariableWithStandardNameAndDimension(ds, "surface_altitude", stationDim, errlog);
        stnTable.lat = lat.getName();
        stnTable.lon = lon.getName();
        if (stnTable.stnId == null) {
            errlog.format("Must have a Station id variable with standard name station_id%n", new Object[0]);
            return null;
        }
        if (info.encoding != Encoding.single) {
            boolean hasStruct = Evaluator.hasRecordStructure(ds) && stationDim.isUnlimited();
            stnTable.structureType = hasStruct ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
            stnTable.dimName = stationDim.getName();
            String string = stnTable.structName = hasStruct ? "record" : stationDim.getName();
        }
        if (stnTable.stnAlt == null && (alt = CoordSysEvaluator.findCoordByType(ds, AxisType.Height)) != null) {
            if (info.encoding == Encoding.single && alt.getRank() == 0) {
                stnTable.stnAlt = alt.getName();
            }
            if (info.encoding != Encoding.single && lat.getRank() == alt.getRank() && alt.getDimension(0).equals(stationDim)) {
                stnTable.stnAlt = alt.getName();
            }
        }
        return stnTable;
    }

    private TableConfig makeStructTable(NetcdfDataset ds, FeatureType ftype, EncodingInfo info, Formatter errlog) throws IOException {
        Table.Type tableType = Table.Type.Structure;
        if (info.encoding == Encoding.single) {
            tableType = Table.Type.Top;
        }
        if (info.encoding == Encoding.flat) {
            tableType = Table.Type.ParentId;
        }
        String name = info.parentDim == null ? " single" : info.parentDim.getName();
        TableConfig tableConfig = new TableConfig(tableType, name);
        tableConfig.lat = this.matchAxisTypeAndDimension(ds, AxisType.Lat, info.parentDim);
        tableConfig.lon = this.matchAxisTypeAndDimension(ds, AxisType.Lon, info.parentDim);
        tableConfig.elev = this.matchAxisTypeAndDimension(ds, AxisType.Height, info.parentDim);
        tableConfig.time = this.matchAxisTypeAndDimension(ds, AxisType.Time, info.parentDim);
        tableConfig.featureType = ftype;
        if (info.encoding != Encoding.single) {
            boolean stnIsStruct = Evaluator.hasRecordStructure(ds) && info.parentDim.isUnlimited();
            tableConfig.structureType = stnIsStruct ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
            tableConfig.dimName = info.parentDim.getName();
            tableConfig.structName = stnIsStruct ? "record" : tableConfig.dimName;
        }
        return tableConfig;
    }

    private TableConfig makeStructTableTestTraj(NetcdfDataset ds, FeatureType ftype, EncodingInfo info, Formatter errlog) throws IOException {
        Table.Type tableType = Table.Type.Structure;
        if (info.encoding == Encoding.single) {
            tableType = Table.Type.Top;
        }
        if (info.encoding == Encoding.flat) {
            tableType = Table.Type.ParentId;
        }
        String name = info.parentDim == null ? " single" : info.parentDim.getName();
        TableConfig tableConfig = new TableConfig(tableType, name);
        tableConfig.lat = CoordSysEvaluator.findCoordNameByType(ds, AxisType.Lat);
        tableConfig.lon = CoordSysEvaluator.findCoordNameByType(ds, AxisType.Lon);
        tableConfig.elev = CoordSysEvaluator.findCoordNameByType(ds, AxisType.Height);
        tableConfig.time = CoordSysEvaluator.findCoordNameByType(ds, AxisType.Time);
        tableConfig.featureType = ftype;
        if (info.encoding != Encoding.single) {
            boolean stnIsStruct = Evaluator.hasRecordStructure(ds) && info.parentDim.isUnlimited();
            tableConfig.structureType = stnIsStruct ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
            tableConfig.dimName = info.parentDim.getName();
            tableConfig.structName = stnIsStruct ? "record" : tableConfig.dimName;
        }
        return tableConfig;
    }

    private TableConfig makeRaggedContiguous(NetcdfDataset ds, Dimension parentDim, Dimension childDim, Formatter errlog) throws IOException {
        TableConfig obsTable = new TableConfig(Table.Type.Contiguous, childDim.getName());
        obsTable.dimName = childDim.getName();
        obsTable.lat = this.matchAxisTypeAndDimension(ds, AxisType.Lat, childDim);
        obsTable.lon = this.matchAxisTypeAndDimension(ds, AxisType.Lon, childDim);
        obsTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.Height, childDim);
        obsTable.time = this.matchAxisTypeAndDimension(ds, AxisType.Time, childDim);
        boolean obsIsStruct = Evaluator.hasRecordStructure(ds) && childDim.isUnlimited();
        obsTable.structName = obsIsStruct ? "record" : childDim.getName();
        obsTable.structureType = obsIsStruct ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
        Variable ragged_rowSize = Evaluator.getVariableWithAttributeValue(ds, "CF:ragged_row_count", childDim.getName());
        if (null == ragged_rowSize || ragged_rowSize.getRank() == 0 || ragged_rowSize.getDimension(0).getName() != parentDim.getName()) {
            errlog.format("there must be a ragged_row_count variable with outer dimension that matches latitude/longitude dimension %s%n", parentDim.getName());
            return null;
        }
        obsTable.numRecords = ragged_rowSize.getName();
        return obsTable;
    }

    private TableConfig makeRaggedIndex(NetcdfDataset ds, Dimension parentDim, Dimension childDim, Formatter errlog) throws IOException {
        TableConfig obsTable = new TableConfig(Table.Type.ParentIndex, childDim.getName());
        obsTable.dimName = childDim.getName();
        obsTable.lat = this.matchAxisTypeAndDimension(ds, AxisType.Lat, childDim);
        obsTable.lon = this.matchAxisTypeAndDimension(ds, AxisType.Lon, childDim);
        obsTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.Height, childDim);
        obsTable.time = this.matchAxisTypeAndDimension(ds, AxisType.Time, childDim);
        boolean obsIsStruct = Evaluator.hasRecordStructure(ds) && childDim.isUnlimited();
        obsTable.structName = obsIsStruct ? "record" : childDim.getName();
        obsTable.structureType = obsIsStruct ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
        Variable ragged_parentIndex = Evaluator.getVariableWithAttributeValue(ds, "CF:ragged_parent_index", parentDim.getName());
        if (null == ragged_parentIndex || ragged_parentIndex.getRank() == 0 || ragged_parentIndex.getDimension(0).getName() != childDim.getName()) {
            errlog.format("there must be a ragged_parent_index variable with outer dimension that matches obs dimension %s%n", childDim.getName());
            return null;
        }
        obsTable.parentIndex = ragged_parentIndex.getName();
        return obsTable;
    }

    private TableConfig makeMultidimInner(NetcdfDataset ds, TableConfig parentTable, Dimension obsDim, Formatter errlog) throws IOException {
        Dimension parentDim = ds.findDimension(parentTable.dimName);
        Table.Type obsTableType = parentTable.structureType == TableConfig.StructureType.PsuedoStructure ? Table.Type.MultidimInnerPsuedo : Table.Type.MultidimInner;
        TableConfig obsTable = new TableConfig(obsTableType, obsDim.getName());
        obsTable.lat = this.matchAxisTypeAndDimension(ds, AxisType.Lat, parentDim, obsDim);
        obsTable.lon = this.matchAxisTypeAndDimension(ds, AxisType.Lon, parentDim, obsDim);
        obsTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.Height, parentDim, obsDim);
        obsTable.time = this.matchAxisTypeAndDimension(ds, AxisType.Time, parentDim, obsDim);
        ArrayList<String> obsVars = null;
        List<Variable> vars = ds.getVariables();
        ArrayList<String> parentVars = new ArrayList<String>(vars.size());
        obsVars = new ArrayList<String>(vars.size());
        for (Variable orgV : vars) {
            Dimension dim0;
            if (orgV instanceof Structure || (dim0 = orgV.getDimension(0)) == null || !dim0.equals(parentDim)) continue;
            if (orgV.getRank() == 1 || orgV.getRank() == 2 && orgV.getDataType() == DataType.CHAR) {
                parentVars.add(orgV.getShortName());
                continue;
            }
            Dimension dim1 = orgV.getDimension(1);
            if (dim1 == null || !dim1.equals(obsDim)) continue;
            obsVars.add(orgV.getShortName());
        }
        parentTable.vars = parentVars;
        obsTable.structureType = parentTable.structureType;
        obsTable.outerName = parentDim.getName();
        obsTable.innerName = obsDim.getName();
        obsTable.dimName = parentTable.structureType == TableConfig.StructureType.PsuedoStructure ? obsTable.outerName : obsTable.innerName;
        obsTable.structName = obsDim.getName();
        obsTable.vars = obsVars;
        return obsTable;
    }

    private TableConfig makeMultidimInner3D(NetcdfDataset ds, TableConfig outerTable, TableConfig middleTable, Dimension innerDim, Formatter errlog) throws IOException {
        Dimension outerDim = ds.findDimension(outerTable.dimName);
        Dimension middleDim = ds.findDimension(middleTable.innerName);
        Table.Type obsTableType = outerTable.structureType == TableConfig.StructureType.PsuedoStructure ? Table.Type.MultidimInnerPsuedo3D : Table.Type.MultidimInner3D;
        TableConfig obsTable = new TableConfig(obsTableType, innerDim.getName());
        obsTable.structureType = TableConfig.StructureType.PsuedoStructure2D;
        obsTable.dimName = outerTable.dimName;
        obsTable.outerName = middleTable.innerName;
        obsTable.innerName = innerDim.getName();
        obsTable.structName = innerDim.getName();
        obsTable.lat = this.matchAxisTypeAndDimension(ds, AxisType.Lat, outerDim, middleDim, innerDim);
        obsTable.lon = this.matchAxisTypeAndDimension(ds, AxisType.Lon, outerDim, middleDim, innerDim);
        obsTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.Height, outerDim, middleDim, innerDim);
        obsTable.time = this.matchAxisTypeAndDimension(ds, AxisType.Time, outerDim, middleDim, innerDim);
        List<Variable> vars = ds.getVariables();
        ArrayList<String> outerVars = new ArrayList<String>(vars.size());
        ArrayList<String> middleVars = new ArrayList<String>(vars.size());
        ArrayList<String> innerVars = new ArrayList<String>(vars.size());
        for (Variable orgV : vars) {
            if (orgV instanceof Structure) continue;
            if (orgV.getRank() == 1 || orgV.getRank() == 2 && orgV.getDataType() == DataType.CHAR) {
                if (!outerDim.equals(orgV.getDimension(0))) continue;
                outerVars.add(orgV.getShortName());
                continue;
            }
            if (orgV.getRank() == 2) {
                if (!outerDim.equals(orgV.getDimension(0)) || !middleDim.equals(orgV.getDimension(1))) continue;
                middleVars.add(orgV.getShortName());
                continue;
            }
            if (orgV.getRank() != 3 || !outerDim.equals(orgV.getDimension(0)) || !middleDim.equals(orgV.getDimension(1)) || !innerDim.equals(orgV.getDimension(2))) continue;
            innerVars.add(orgV.getShortName());
        }
        outerTable.vars = outerVars;
        middleTable.vars = middleVars;
        obsTable.vars = innerVars;
        return obsTable;
    }

    private TableConfig makeSingle(NetcdfDataset ds, Dimension obsDim, Formatter errlog) throws IOException {
        Table.Type obsTableType = Table.Type.Structure;
        TableConfig obsTable = new TableConfig(obsTableType, "single");
        obsTable.dimName = obsDim.getName();
        obsTable.lat = this.matchAxisTypeAndDimension(ds, AxisType.Lat, obsDim);
        obsTable.lon = this.matchAxisTypeAndDimension(ds, AxisType.Lon, obsDim);
        obsTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.Height, obsDim);
        obsTable.time = this.matchAxisTypeAndDimension(ds, AxisType.Time, obsDim);
        boolean obsIsStruct = Evaluator.hasRecordStructure(ds) && obsDim.isUnlimited();
        obsTable.structName = obsIsStruct ? "record" : obsDim.getName();
        obsTable.structureType = obsIsStruct ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
        return obsTable;
    }

    private TableConfig makeMiddleTable(NetcdfDataset ds, TableConfig parentTable, Dimension obsDim, Formatter errlog) throws IOException {
        throw new UnsupportedOperationException("CFpointObs: middleTable encoding");
    }

    @Override
    protected String matchAxisTypeAndDimension(NetcdfDataset ds, AxisType type, final Dimension outer) {
        CoordinateAxis var = CoordSysEvaluator.findCoordByType(ds, type, new CoordSysEvaluator.Predicate(){

            @Override
            public boolean match(CoordinateAxis axis) {
                if (outer == null && axis.getRank() == 0) {
                    return true;
                }
                if (outer != null && axis.getRank() == 1 && outer.equals(axis.getDimension(0))) {
                    return true;
                }
                if (axis.getParentStructure() != null) {
                    Structure parent = axis.getParentStructure();
                    if (outer != null && parent.getRank() == 1 && outer.equals(parent.getDimension(0))) {
                        return true;
                    }
                }
                return false;
            }
        });
        if (var == null) {
            return null;
        }
        return var.getShortName();
    }

    private class EncodingInfo {
        Encoding encoding;
        Dimension parentDim;
        Dimension childDim;
        Dimension grandChildDim;

        EncodingInfo(Encoding encoding, Dimension parentDim) {
            this.encoding = encoding;
            this.parentDim = parentDim;
        }

        EncodingInfo(Encoding encoding, Dimension parentDim, Dimension childDim) {
            this.encoding = encoding;
            this.parentDim = parentDim;
            this.childDim = childDim;
        }

        EncodingInfo(Encoding encoding, Dimension parentDim, Dimension childDim, Dimension grandChildDim) {
            this.encoding = encoding;
            this.parentDim = parentDim;
            this.childDim = childDim;
            this.grandChildDim = grandChildDim;
        }

        EncodingInfo(Encoding encoding, Variable v) {
            this.encoding = encoding;
            this.parentDim = v == null ? null : v.getDimension(0);
        }
    }

    private static enum Encoding {
        single,
        multidim,
        raggedContiguous,
        raggedIndex,
        flat;

    }
}

