/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import javax.security.auth.Subject;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.security.gridmap.GridMap;
import org.globus.util.I18n;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.impl.security.authorization.ServiceAuthorizationChain;
import org.globus.wsrf.impl.security.descriptor.SecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.util.ElementParserException;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.impl.security.util.PDPUtils;
import org.globus.wsrf.security.SecurityException;
import org.globus.wsrf.utils.ContextUtils;
import org.w3c.dom.Document;

public class ServiceSecurityConfig
extends SecurityConfig {
    private static Log logger = LogFactory.getLog(ServiceSecurityConfig.class.getName());
    private static I18n i18n = I18n.getI18n("org.globus.wsrf.impl.security.descriptor.errors", SecurityConfig.class.getClassLoader());

    ServiceSecurityConfig(String jndiPath, ServiceSecurityDescriptor desc) {
        super(jndiPath, desc);
    }

    ServiceSecurityConfig(String servicePath, String descFilename) throws SecurityException {
        this.jndiPathName = servicePath;
        this.descriptorFile = descFilename;
        logger.debug("Service: " + this.jndiPathName + " Desc file" + this.descriptorFile);
    }

    public static void initialize(MessageContext msgCtx) throws ConfigException, SecurityException {
        ServiceSecurityConfig.initialize(ContextUtils.getTargetServicePath(msgCtx), null);
    }

    public static void initialize(String servicePath) throws ConfigException, SecurityException {
        ServiceSecurityConfig.initialize(servicePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(String servicePath, String serviceDescFile) throws ConfigException, SecurityException {
        if (servicePath == null) {
            return;
        }
        if (serviceDescFile == null && (serviceDescFile = AuthUtil.getSecurityDescFile(servicePath)) == null) {
            logger.debug("No security descriptor for: " + servicePath);
            return;
        }
        String string = servicePath = servicePath.intern();
        synchronized (string) {
            if (ServiceSecurityConfig.isInitialized(servicePath)) {
                logger.debug("Already initialized: " + servicePath);
                return;
            }
            logger.debug(i18n.getMessage("serviceDescInit", servicePath));
            ServiceSecurityConfig config = new ServiceSecurityConfig(servicePath, serviceDescFile);
            config.initialize();
            logger.debug("Initialized: " + servicePath);
        }
    }

    protected void initialize() throws ConfigException {
        try {
            super.initialize();
        }
        catch (ConfigException e) {
            throw new ConfigException(i18n.getMessage("serviceInitFail", this.jndiPathName), e);
        }
    }

    protected void initSecurityDescriptor(Document doc) throws ConfigException {
        if (doc != null) {
            try {
                this.desc = new ServiceSecurityDescriptor();
                this.desc.parse(doc.getDocumentElement());
            }
            catch (ElementParserException e) {
                throw new ConfigException(e);
            }
        }
    }

    protected void initCredentials() throws ConfigException {
        try {
            this.loadCredentials();
        }
        catch (Exception exp) {
            throw new ConfigException(exp);
        }
    }

    protected void loadAuthorization() throws ConfigException {
        if (this.desc == null) {
            return;
        }
        String authzType = this.desc.getAuthz();
        if (authzType != null) {
            ServiceAuthorizationChain authzChain = PDPUtils.getServiceAuthzChain(authzType, this.jndiPathName);
            this.desc.setAuthzChain(authzChain);
        }
    }

    public static Subject getSubject(String servicePath) throws ConfigException, SecurityException {
        ServiceSecurityConfig.refresh(servicePath);
        return ServiceSecurityConfig.retrieveSubject(servicePath);
    }

    public static ServiceAuthorizationChain getAuthzChain(String servicePath) throws ConfigException {
        return ServiceSecurityConfig.retrieveAuthzChain(servicePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh(String jndiPath) throws ConfigException, SecurityException {
        logger.debug("Refresh called " + jndiPath);
        if (jndiPath == null) {
            return;
        }
        jndiPath = jndiPath.intern();
        ServiceSecurityConfig.initialize(jndiPath);
        String string = jndiPath;
        synchronized (string) {
            boolean refreshReq = ServiceSecurityConfig.isRefreshRequired(jndiPath);
            if (refreshReq) {
                logger.debug(i18n.getMessage("serviceDescRefresh", jndiPath));
                ServiceSecurityDescriptor secDesc = ServiceSecurityConfig.getSecurityDescriptor(jndiPath);
                ServiceSecurityConfig config = new ServiceSecurityConfig(jndiPath, secDesc);
                config.initCredentials();
                config.storeSecurityDescriptor();
            }
        }
    }

    public static void setSubject(Subject subject, String jndiPath) throws ConfigException {
        ServiceSecurityDescriptor desc = (ServiceSecurityDescriptor)ServiceSecurityConfig.retrieveSecurityDescriptor(jndiPath);
        if (desc == null) {
            desc = new ServiceSecurityDescriptor();
        }
        ServiceSecurityConfig.storeSubject(subject, jndiPath, desc);
    }

    public static void setGridMap(GridMap gridmap, String jndiPath) throws ConfigException {
        ServiceSecurityDescriptor desc = (ServiceSecurityDescriptor)ServiceSecurityConfig.retrieveSecurityDescriptor(jndiPath);
        if (desc == null) {
            desc = new ServiceSecurityDescriptor();
        }
        ServiceSecurityConfig.storeGridMap(gridmap, jndiPath, desc);
    }

    public static void setAuthzChain(ServiceAuthorizationChain authzChain, String jndiPath) throws ConfigException {
        ServiceSecurityDescriptor desc = (ServiceSecurityDescriptor)ServiceSecurityConfig.retrieveSecurityDescriptor(jndiPath);
        if (desc == null) {
            desc = new ServiceSecurityDescriptor();
        }
        ServiceSecurityConfig.storeAuthzChain(authzChain, jndiPath, desc);
    }

    public static void setSecurityDescriptor(ServiceSecurityDescriptor desc, String jndiPath) throws ConfigException {
        ServiceSecurityConfig.storeSecurityDescriptor(desc, jndiPath);
    }

    public static GridMap getGridMap(String jndiPath) throws ConfigException {
        logger.debug("Get gridmap " + jndiPath);
        return ServiceSecurityConfig.retrieveGridMap(jndiPath);
    }

    public static ServiceSecurityDescriptor getSecurityDescriptor(String jndiPath) throws ConfigException {
        logger.debug("Get descriptor " + jndiPath);
        return (ServiceSecurityDescriptor)ServiceSecurityConfig.retrieveSecurityDescriptor(jndiPath);
    }

    public static ServiceSecurityDescriptor getSecurityDescriptor() throws ConfigException {
        String jndiPath = ContextUtils.getTargetServicePath(MessageContext.getCurrentContext());
        logger.debug("Get descriptor " + jndiPath);
        return (ServiceSecurityDescriptor)ServiceSecurityConfig.retrieveSecurityDescriptor(jndiPath);
    }
}

