/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.security.gridmap.GridMap;
import org.globus.wsrf.Resource;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.impl.security.authorization.ServiceAuthorizationChain;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.SecureResourcePropertiesHelper;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;

public class SecurityPropertiesHelper {
    private static Log logger = LogFactory.getLog(SecurityPropertiesHelper.class.getName());

    public static Integer getContextLifetime(String servicePath, Resource resource) throws ConfigException {
        ContainerSecurityDescriptor containerDesc;
        logger.debug("getContext lifetime " + servicePath);
        Integer contextLifetime = SecureResourcePropertiesHelper.getContextLifetime(resource);
        if (contextLifetime != null) {
            return contextLifetime;
        }
        ServiceSecurityDescriptor desc = SecurityPropertiesHelper.getSecurityDesc(servicePath);
        if (desc != null) {
            contextLifetime = desc.getContextLifetime();
        }
        if (contextLifetime == null && (containerDesc = ContainerSecurityConfig.getConfig().getSecurityDescriptor()) != null) {
            contextLifetime = containerDesc.getContextLifetime();
        }
        return contextLifetime;
    }

    public static Boolean getRejectLimitedProxyState(String servicePath, Resource res) throws ConfigException {
        logger.debug("getRejectLimitedProxyState " + servicePath);
        String state = SecureResourcePropertiesHelper.getRejectLimitedProxyState(res);
        logger.debug("State is " + state);
        if (state == null) {
            ContainerSecurityDescriptor containerDesc;
            ServiceSecurityDescriptor desc = SecurityPropertiesHelper.getSecurityDesc(servicePath);
            if (desc != null) {
                state = desc.getRejectLimitedProxyState();
            }
            logger.debug("Service state is " + state);
            if (state == null && (containerDesc = ContainerSecurityConfig.getConfig().getSecurityDescriptor()) != null) {
                logger.debug("Container desc is not null");
                state = containerDesc.getRejectLimitedProxyState();
            }
        }
        logger.debug("State is " + state);
        if (state == null) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(state);
    }

    public static String getReplayAttackWindow(String servicePath, Resource resource) throws ConfigException {
        ContainerSecurityDescriptor containerDesc;
        logger.debug("getReplayAttackWindow for " + servicePath);
        String replayWin = SecureResourcePropertiesHelper.getReplayAttackWindow(resource);
        if (replayWin != null) {
            logger.debug("Replay Window is " + replayWin);
            return replayWin;
        }
        ServiceSecurityDescriptor desc = ServiceSecurityConfig.getSecurityDescriptor(servicePath);
        if (desc != null) {
            replayWin = desc.getReplayAttackWindow();
        }
        logger.debug("Replay Window is " + replayWin);
        if (replayWin == null && (containerDesc = ContainerSecurityConfig.getConfig().getSecurityDescriptor()) != null) {
            logger.debug("Container descriptor is null");
            replayWin = containerDesc.getReplayAttackWindow();
        }
        return replayWin;
    }

    public static String getReplayAttackFilter(String servicePath, Resource resource) throws ConfigException {
        ContainerSecurityDescriptor containerDesc;
        logger.debug("getReplayAttackFilyer for " + servicePath);
        String replayWin = SecureResourcePropertiesHelper.getReplayAttackFilter(resource);
        if (replayWin != null) {
            logger.debug("Replay Window is " + replayWin);
            return replayWin;
        }
        ServiceSecurityDescriptor desc = ServiceSecurityConfig.getSecurityDescriptor(servicePath);
        if (desc != null) {
            replayWin = desc.getReplayAttackFilter();
        }
        logger.debug("Replay Window is " + replayWin);
        if (replayWin == null && (containerDesc = ContainerSecurityConfig.getConfig().getSecurityDescriptor()) != null) {
            replayWin = containerDesc.getReplayAttackFilter();
        }
        return replayWin;
    }

    public static String getAuthorizationType(String servicePath, Resource resource) throws ConfigException {
        ContainerSecurityDescriptor containerDesc;
        logger.debug("GetAuthzType " + servicePath);
        String authz = SecureResourcePropertiesHelper.getAuthorizationType(resource);
        if (authz != null) {
            logger.debug("Auth is " + authz);
            return authz;
        }
        ServiceSecurityDescriptor desc = ServiceSecurityConfig.getSecurityDescriptor(servicePath);
        if (desc != null) {
            authz = desc.getAuthz();
        }
        logger.debug("Auth is " + authz);
        if (authz == null && (containerDesc = ContainerSecurityConfig.getConfig().getSecurityDescriptor()) != null) {
            authz = containerDesc.getAuthz();
        }
        return authz;
    }

    public static GridMap getGridMap(String servicePath, Resource resource) throws ConfigException {
        logger.debug("getGridMap " + servicePath);
        GridMap obj = SecureResourcePropertiesHelper.getGridMap(resource);
        if (obj != null) {
            return obj;
        }
        obj = ServiceSecurityConfig.getGridMap(servicePath);
        if (obj == null) {
            logger.debug("Service gridmap null");
            obj = ContainerSecurityConfig.getConfig().getGridMap();
        }
        return obj;
    }

    public static ServiceAuthorizationChain getAuthzChain(String servicePath, Resource resource) throws ConfigException {
        logger.debug("get authz chain " + servicePath);
        ServiceAuthorizationChain obj = SecureResourcePropertiesHelper.getAuthzChain(resource);
        if (obj != null) {
            logger.debug("Resource authz is not null");
            return obj;
        }
        logger.debug("resource authz is null " + servicePath);
        obj = ServiceSecurityConfig.getAuthzChain(servicePath);
        if (obj == null) {
            logger.debug("service authz is null");
            obj = ContainerSecurityConfig.getConfig().getAuthzChain();
        } else {
            logger.debug("service authz is not null");
        }
        return obj;
    }

    public static boolean gridMapPresent(String servicePath, Resource resource) throws ConfigException {
        return SecurityPropertiesHelper.getGridMap(servicePath, resource) != null;
    }

    private static ServiceSecurityDescriptor getSecurityDesc(String servicePath) throws ConfigException {
        try {
            ServiceSecurityConfig.initialize(servicePath);
        }
        catch (Exception exp) {
            throw new ConfigException(exp);
        }
        return ServiceSecurityConfig.getSecurityDescriptor(servicePath);
    }
}

