/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.descriptor;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.globus.security.gridmap.GridMap;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authorization.ServiceAuthorizationChain;
import org.globus.wsrf.impl.security.descriptor.AuthzParamParser;
import org.globus.wsrf.impl.security.descriptor.AuthzParamParserCallback;
import org.globus.wsrf.impl.security.descriptor.CredentialParamsParser;
import org.globus.wsrf.impl.security.descriptor.CredentialParamsParserCallback;
import org.globus.wsrf.impl.security.descriptor.GlobalParamsParser;
import org.globus.wsrf.impl.security.descriptor.GlobalParamsParserCallback;
import org.globus.wsrf.impl.security.descriptor.util.ElementParser;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.impl.security.util.FixedObjectInputStream;

public class SecurityDescriptor
extends ElementParser
implements GlobalParamsParserCallback,
CredentialParamsParserCallback,
AuthzParamParserCallback,
Serializable {
    public static final String RESOURCE = "org.globus.wsrf.impl.security.descriptor.errors";
    protected static I18n i18n = I18n.getI18n("org.globus.wsrf.impl.security.descriptor.errors");
    public static final String NS = "http://www.globus.org";
    private static final QName QNAME = new QName("http://www.globus.org", "securityConfig");
    private String rejectLimitedProxy = null;
    private String proxyFile = null;
    private String certFile = null;
    private String keyFile = null;
    private String authz = null;
    private String gridMapFile = null;
    private String replayFilter = null;
    private String replayWindow = null;
    private Integer contextLifetime = null;
    private Subject subject = null;
    private Long lastModified = null;
    private GridMap gridMap = null;
    private ServiceAuthorizationChain authzChain = null;

    public SecurityDescriptor() {
        super(QNAME);
        this.register(GlobalParamsParser.CONTEXT_LIFETIME_QNAME, new GlobalParamsParser(this));
        this.register(GlobalParamsParser.REJECT_LIMITED_PROXY_QNAME, new GlobalParamsParser(this));
        this.register(GlobalParamsParser.GRID_MAP_QNAME, new GlobalParamsParser(this));
        this.register(GlobalParamsParser.REPLAY_ATTACK_FILTER_QNAME, new GlobalParamsParser(this));
        this.register(GlobalParamsParser.REPLAY_ATTACK_WINDOW_QNAME, new GlobalParamsParser(this));
        this.register(CredentialParamsParser.PROXY_FILE_QNAME, new CredentialParamsParser(this));
        this.register(CredentialParamsParser.CREDENTIAL_QNAME, new CredentialParamsParser(this));
        this.register(AuthzParamParser.AUTHZ_QNAME, new AuthzParamParser(this));
    }

    public void setRejectLimitedProxy(String value) {
        this.rejectLimitedProxy = value;
    }

    public String getRejectLimitedProxyState() {
        return this.rejectLimitedProxy;
    }

    public void setProxyFilename(String value) {
        this.proxyFile = value;
    }

    public void setCertificateFiles(String certName, String keyName) {
        this.certFile = certName;
        this.keyFile = keyName;
    }

    public String getProxyFilename() {
        return this.proxyFile;
    }

    public String getCertFilename() {
        return this.certFile;
    }

    public String getKeyFilename() {
        return this.keyFile;
    }

    public void setAuthz(String value) {
        this.authz = value;
    }

    public String getAuthz() {
        return this.authz;
    }

    public void setAuthzChain(ServiceAuthorizationChain chain) {
        this.authzChain = chain;
    }

    public ServiceAuthorizationChain getAuthzChain() {
        return this.authzChain;
    }

    public void setGridMapFile(String value) {
        this.gridMapFile = value;
    }

    public String getGridMapFile() {
        return this.gridMapFile;
    }

    public void setReplayAttackFilter(String value) {
        this.replayFilter = value;
    }

    public String getReplayAttackFilter() {
        return this.replayFilter;
    }

    public void setReplayAttackWindow(String value) {
        this.replayWindow = value;
    }

    public String getReplayAttackWindow() {
        return this.replayWindow;
    }

    public void setContextLifetime(Integer lifetime) {
        this.contextLifetime = lifetime;
    }

    public Integer getContextLifetime() {
        return this.contextLifetime;
    }

    public void setSubject(Subject sub) {
        this.subject = sub;
    }

    public void setLastModified(Long modified) {
        this.lastModified = modified;
    }

    public void setGridMap(GridMap map) {
        this.gridMap = map;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public GridMap getGridMap() {
        return this.gridMap;
    }

    public boolean isRefreshRequired() {
        String credFile = this.getCertFilename();
        if (credFile == null) {
            credFile = this.getProxyFilename();
        }
        if (credFile == null) {
            return false;
        }
        File file = new File(credFile);
        Long lastModified = this.getLastModified();
        return lastModified == null || lastModified.longValue() != file.lastModified();
    }

    protected void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.rejectLimitedProxy);
        oos.writeObject(this.proxyFile);
        oos.writeObject(this.certFile);
        oos.writeObject(this.keyFile);
        oos.writeObject(this.authz);
        oos.writeObject(this.gridMapFile);
        oos.writeObject(this.replayFilter);
        oos.writeObject(this.replayWindow);
        oos.writeObject(this.contextLifetime);
        AuthUtil.writeSubject(this.subject, oos);
        oos.writeObject(this.lastModified);
        oos.writeObject(this.gridMap);
        oos.writeObject(this.authzChain);
    }

    protected void readObject(FixedObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.rejectLimitedProxy = (String)ois.readObject();
        this.proxyFile = (String)ois.readObject();
        this.certFile = (String)ois.readObject();
        this.keyFile = (String)ois.readObject();
        this.authz = (String)ois.readObject();
        this.gridMapFile = (String)ois.readObject();
        this.replayFilter = (String)ois.readObject();
        this.replayWindow = (String)ois.readObject();
        this.contextLifetime = (Integer)ois.readObject();
        this.subject = AuthUtil.readSubject(ois);
        this.lastModified = (Long)ois.readObject();
        this.gridMap = (GridMap)ois.readObject();
        this.authzChain = (ServiceAuthorizationChain)ois.readObject();
    }
}

