/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class WARDirContext
extends BaseDirContext {
    private static Log log = LogFactory.getLog(class$org$apache$naming$resources$WARDirContext == null ? (class$org$apache$naming$resources$WARDirContext = WARDirContext.class$("org.apache.naming.resources.WARDirContext")) : class$org$apache$naming$resources$WARDirContext);
    protected ZipFile base = null;
    protected Entry entries = null;
    static /* synthetic */ Class class$org$apache$naming$resources$WARDirContext;

    public WARDirContext() {
    }

    public WARDirContext(Hashtable hashtable) {
        super(hashtable);
    }

    protected WARDirContext(ZipFile zipFile, Entry entry) {
        this.base = zipFile;
        this.entries = entry;
    }

    public void setDocBase(String string) {
        if (string == null) {
            throw new IllegalArgumentException(this.sm.getString("resources.null"));
        }
        if (!string.endsWith(".war")) {
            throw new IllegalArgumentException(this.sm.getString("warResources.notWar"));
        }
        File file = new File(string);
        if (!file.exists() || !file.canRead() || file.isDirectory()) {
            throw new IllegalArgumentException(this.sm.getString("warResources.invalidWar", string));
        }
        try {
            this.base = new ZipFile(file);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(this.sm.getString("warResources.invalidWar", exception.getMessage()));
        }
        super.setDocBase(string);
        this.loadEntries();
    }

    public void release() {
        this.entries = null;
        if (this.base != null) {
            try {
                this.base.close();
            }
            catch (IOException iOException) {
                log.warn("Exception closing WAR File " + this.base.getName(), iOException);
            }
        }
        this.base = null;
        super.release();
    }

    public Object lookup(String string) throws NamingException {
        return this.lookup(new CompositeName(string));
    }

    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this;
        }
        Entry entry = this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        ZipEntry zipEntry = entry.getEntry();
        if (zipEntry.isDirectory()) {
            return new WARDirContext(this.base, entry);
        }
        return new WARResource(entry.getEntry());
    }

    public void unbind(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(String string, String string2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.list(new CompositeName(string));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new NamingContextEnumeration(((AbstractList)this.list(this.entries)).iterator());
        }
        Entry entry = this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        return new NamingContextEnumeration(((AbstractList)this.list(entry)).iterator());
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.listBindings(new CompositeName(string));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new NamingContextBindingsEnumeration(((AbstractList)this.list(this.entries)).iterator());
        }
        Entry entry = this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        return new NamingContextBindingsEnumeration(((AbstractList)this.list(entry)).iterator());
    }

    public void destroySubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    public String getNameInNamespace() throws NamingException {
        return this.docBase;
    }

    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        return this.getAttributes(new CompositeName(string), stringArray);
    }

    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        Entry entry = null;
        entry = name.isEmpty() ? this.entries : this.treeLookup(name);
        if (entry == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        ZipEntry zipEntry = entry.getEntry();
        ResourceAttributes resourceAttributes = new ResourceAttributes();
        resourceAttributes.setCreationDate(new Date(zipEntry.getTime()));
        resourceAttributes.setName(entry.getName());
        if (!zipEntry.isDirectory()) {
            resourceAttributes.setResourceType("");
        }
        resourceAttributes.setContentLength(zipEntry.getSize());
        resourceAttributes.setLastModified(zipEntry.getTime());
        return resourceAttributes;
    }

    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchema(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String string, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String string, String string2, SearchControls searchControls) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected String normalize(ZipEntry zipEntry) {
        String string = "/" + zipEntry.getName();
        if (zipEntry.isDirectory()) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected void loadEntries() {
        try {
            Enumeration<? extends ZipEntry> enumeration = this.base.entries();
            this.entries = new Entry("/", new ZipEntry("/"));
            while (enumeration.hasMoreElements()) {
                Entry entry;
                Object object;
                CompositeName compositeName;
                Object object2;
                ZipEntry zipEntry = enumeration.nextElement();
                String string = this.normalize(zipEntry);
                int n = string.lastIndexOf(47);
                int n2 = -1;
                int n3 = 0;
                while ((n2 = string.indexOf(47, n3)) != -1) {
                    object2 = new CompositeName(string.substring(0, n3));
                    compositeName = new CompositeName(string.substring(0, n2));
                    object = string.substring(n3, n2);
                    entry = this.treeLookup((Name)object2);
                    Entry entry2 = this.treeLookup(compositeName);
                    if (entry2 == null) {
                        String string2 = string.substring(1, n2) + "/";
                        entry2 = new Entry((String)object, new ZipEntry(string2));
                        if (entry != null) {
                            entry.addChild(entry2);
                        }
                    }
                    n3 = n2 + 1;
                }
                object2 = string.substring(n + 1, string.length());
                compositeName = new CompositeName(string.substring(0, n));
                object = this.treeLookup(compositeName);
                entry = new Entry((String)object2, zipEntry);
                if (object == null) continue;
                ((Entry)object).addChild(entry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Entry treeLookup(Name name) {
        if (name.isEmpty()) {
            return this.entries;
        }
        Entry entry = this.entries;
        int n = 0;
        while (n < name.size()) {
            if (name.get(n).length() != 0 && (entry = entry.getChild(name.get(n))) == null) {
                return null;
            }
            ++n;
        }
        return entry;
    }

    protected ArrayList list(Entry entry) {
        ArrayList<NamingEntry> arrayList = new ArrayList<NamingEntry>();
        Object[] objectArray = entry.getChildren();
        Arrays.sort(objectArray);
        NamingEntry namingEntry = null;
        int n = 0;
        while (n < objectArray.length) {
            ZipEntry zipEntry = ((Entry)objectArray[n]).getEntry();
            Object object = null;
            object = zipEntry.isDirectory() ? new WARDirContext(this.base, (Entry)objectArray[n]) : new WARResource(zipEntry);
            namingEntry = new NamingEntry(((Entry)objectArray[n]).getName(), object, 0);
            arrayList.add(namingEntry);
            ++n;
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class WARResource
    extends Resource {
        protected ZipEntry entry;

        public WARResource(ZipEntry zipEntry) {
            this.entry = zipEntry;
        }

        public InputStream streamContent() throws IOException {
            try {
                if (this.binaryContent == null) {
                    this.inputStream = WARDirContext.this.base.getInputStream(this.entry);
                }
            }
            catch (ZipException zipException) {
                throw new IOException(zipException.getMessage());
            }
            return super.streamContent();
        }
    }

    protected class Entry
    implements Comparable {
        protected String name = null;
        protected ZipEntry entry = null;
        protected Entry[] children = new Entry[0];

        public Entry(String string, ZipEntry zipEntry) {
            this.name = string;
            this.entry = zipEntry;
        }

        public int compareTo(Object object) {
            if (!(object instanceof Entry)) {
                return 1;
            }
            return this.name.compareTo(((Entry)object).getName());
        }

        public ZipEntry getEntry() {
            return this.entry;
        }

        public String getName() {
            return this.name;
        }

        public void addChild(Entry entry) {
            Entry[] entryArray = new Entry[this.children.length + 1];
            int n = 0;
            while (n < this.children.length) {
                entryArray[n] = this.children[n];
                ++n;
            }
            entryArray[this.children.length] = entry;
            this.children = entryArray;
        }

        public Entry[] getChildren() {
            return this.children;
        }

        public Entry getChild(String string) {
            int n = 0;
            while (n < this.children.length) {
                if (this.children[n].name.equals(string)) {
                    return this.children[n];
                }
                ++n;
            }
            return null;
        }
    }
}

