/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.BoundedChannel;
import EDU.oswego.cs.dl.util.concurrent.CondVar;
import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
import EDU.oswego.cs.dl.util.concurrent.Mutex;

public class CVBuffer
implements BoundedChannel {
    private final Mutex mutex;
    private final CondVar notFull;
    private final CondVar notEmpty;
    private int count = 0;
    private int takePtr = 0;
    private int putPtr = 0;
    private final Object[] array;

    public CVBuffer(int n) {
        this.array = new Object[n];
        this.mutex = new Mutex();
        this.notFull = new CondVar(this.mutex);
        this.notEmpty = new CondVar(this.mutex);
    }

    public CVBuffer() {
        this(DefaultChannelCapacity.get());
    }

    public int capacity() {
        return this.array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object) throws InterruptedException {
        this.mutex.acquire();
        try {
            while (this.count == this.array.length) {
                this.notFull.await();
            }
            this.array[this.putPtr] = object;
            this.putPtr = (this.putPtr + 1) % this.array.length;
            ++this.count;
            this.notEmpty.signal();
            Object var3_2 = null;
            this.mutex.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mutex.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        Object object = null;
        this.mutex.acquire();
        try {
            while (this.count == 0) {
                this.notEmpty.await();
            }
            object = this.array[this.takePtr];
            this.array[this.takePtr] = null;
            this.takePtr = (this.takePtr + 1) % this.array.length;
            --this.count;
            this.notFull.signal();
            Object var3_2 = null;
            this.mutex.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mutex.release();
            throw throwable;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object object, long l) throws InterruptedException {
        block3: {
            this.mutex.acquire();
            try {
                if (this.count != this.array.length) break block3;
                this.notFull.timedwait(l);
                if (this.count != this.array.length) break block3;
                boolean bl = false;
                Object var6_5 = null;
                this.mutex.release();
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.mutex.release();
                throw throwable;
            }
        }
        this.array[this.putPtr] = object;
        this.putPtr = (this.putPtr + 1) % this.array.length;
        ++this.count;
        this.notEmpty.signal();
        boolean bl = true;
        Object var6_6 = null;
        this.mutex.release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(long l) throws InterruptedException {
        Object object;
        block3: {
            object = null;
            this.mutex.acquire();
            try {
                if (this.count != 0) break block3;
                this.notEmpty.timedwait(l);
                if (this.count != 0) break block3;
                Object var4_3 = null;
                Object var6_4 = null;
                this.mutex.release();
                return var4_3;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.mutex.release();
                throw throwable;
            }
        }
        object = this.array[this.takePtr];
        this.array[this.takePtr] = null;
        this.takePtr = (this.takePtr + 1) % this.array.length;
        --this.count;
        this.notFull.signal();
        Object var6_5 = null;
        this.mutex.release();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object peek() {
        try {
            Object object;
            this.mutex.acquire();
            try {
                if (this.count == 0) {
                    Object var1_1 = null;
                    Object var4_3 = null;
                    this.mutex.release();
                    return var1_1;
                }
                object = this.array[this.takePtr];
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.mutex.release();
                throw throwable;
            }
            Object var4_4 = null;
            this.mutex.release();
            return object;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }
}

