/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport;

import com.mongodb.MongoException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Map;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;

public abstract class TransportManager {
    public String downloadManager(MyFile myFile, String key, Class<? extends Object> type) throws IOException {
        String key4lock = null;
        if (myFile.isLock()) {
            key4lock = this.lock(myFile, key, type);
        } else {
            this.get(myFile, key, type);
        }
        return key4lock;
    }

    public String uploadManager(Object resource, String bucket, String key, boolean replace) throws FileNotFoundException, UnknownHostException, MongoException {
        String id = null;
        MyFile file = (MyFile)resource;
        id = file.getLockedKey() != null && !file.getLockedKey().isEmpty() ? this.unlock(resource, bucket, key, file.getLockedKey()) : this.put(resource, bucket, key, replace);
        return id;
    }

    public abstract Object get(MyFile var1, String var2, Class<? extends Object> var3) throws FileNotFoundException, IOException;

    public String getAndLock(MyFile myFile, String key, Class<? extends Object> type) throws FileNotFoundException, IOException {
        throw new IllegalStateException("Operation not implemented for the client specified");
    }

    public abstract String put(Object var1, String var2, String var3, boolean var4) throws UnknownHostException, MongoException;

    public String putAndUnlock(Object resource, String bucket, String key, String key4unlock) throws FileNotFoundException, UnknownHostException, MongoException {
        throw new IllegalStateException("Operation not implemented for the client specified");
    }

    public abstract Map getValues(String var1, Class<? extends Object> var2) throws UnknownHostException, MongoException;

    public abstract void clearBucket(String var1) throws UnknownHostException, MongoException;

    public abstract void removeKey(String var1, String var2);

    public abstract void removeDir(String var1) throws UnknownHostException, MongoException;

    public abstract Map getValuesPredicate(String var1, Class<? extends Object> var2, String var3);

    public long getSize(String bucket) throws UnknownHostException, MongoException {
        return -1L;
    }

    public String lock(MyFile resource, String serverLocation, Class<? extends Object> type) throws IOException {
        return null;
    }

    public String unlock(Object resource, String bucket, String key, String key4unlock) throws FileNotFoundException, UnknownHostException, MongoException {
        return null;
    }

    public abstract long getTTL(String var1) throws UnknownHostException, MongoException;

    public abstract long renewTTL(MyFile var1) throws UnknownHostException, MongoException, IllegalAccessException;
}

