/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import com.mongodb.MongoException;
import java.io.OutputStream;
import java.net.UnknownHostException;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewTTL
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Download.class);
    private String localPath;
    private String remotePath;
    private OutputStream os;

    public RenewTTL(String[] server, String bucket, Monitor monitor, boolean isChunk) {
        super(server, bucket, monitor, isChunk);
    }

    @Override
    public String doIt(MyFile myFile) throws IllegalAccessException {
        TransportManagerFactory tmf = new TransportManagerFactory(this.server);
        TransportManager tm = tmf.getTransport("mongo");
        long ttl = -1L;
        try {
            myFile.setPathServer(this.bucket);
            ttl = tm.renewTTL(myFile);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (MongoException e) {
            e.printStackTrace();
        }
        return ttl + "";
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        String bucketName;
        this.localPath = file.getPathClient();
        this.remotePath = remotePath;
        this.bucket = bucketName = new BucketCoding().bucketFileCoding(remotePath, author, rootArea);
        return this.bucket;
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        return null;
    }
}

