/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.IOException;
import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadAndLock
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Download.class);
    private String localPath;
    private String remotePath;
    private OutputStream os;

    public DownloadAndLock(String[] server, String bucket, Monitor monitor, boolean isChunk) {
        super(server, bucket, monitor, isChunk);
    }

    @Override
    public String doIt(MyFile myFile) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" DOWNLOAD " + myFile.getPathServer() + " in bucket: " + this.bucket);
        }
        try {
            this.get(myFile, true);
        }
        catch (IOException e) {
            this.logger.error("doIt(MyFile) - problemi con il file " + myFile.getPathClient(), (Throwable)e);
        }
        catch (InterruptedException e) {
            this.logger.error("doIt(MyFile) - problemi con i thread ");
            this.logger.error("doIt(MyFile)", (Throwable)e);
        }
        return null;
    }

    @Override
    public String initOperation(MyFile file, String RemotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        String bucketName;
        this.localPath = file.getPathClient();
        this.remotePath = this.remotePath;
        this.bucket = bucketName = new BucketCoding().bucketFileCoding(this.remotePath, author, rootArea);
        return this.bucket;
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        return null;
    }
}

