/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryBucket;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryEntity;
import org.gcube.contentmanagement.blobstorage.service.impl.LocalResource;
import org.gcube.contentmanagement.blobstorage.service.impl.RemoteResource;
import org.gcube.contentmanagement.blobstorage.service.impl.RemoteResourceInfo;
import org.gcube.contentmanagement.blobstorage.service.operation.OperationManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceEngine
implements IClient {
    final Logger logger = LoggerFactory.getLogger(ServiceEngine.class);
    public static final String FILE_SEPARATOR = "/";
    public String[] server;
    protected OperationManager service;
    protected MyFile file;
    protected String bucket;
    protected String bucketID;
    protected String author;
    protected String owner;
    protected String environment;
    protected String currentOperation;
    protected boolean replaceOption;
    public static final String DEFAULT_SCOPE = "private";
    public static final long TTL = 180000L;
    public static final boolean DEFAULT_CHUNK_OPTION = false;
    public static final int TTL_RENEW = 5;
    protected String publicArea;
    protected String homeArea;
    protected Map<String, String> attributes;
    private String scope;
    private String serviceName;
    private String ownerGcube;
    private String gcubeScope;
    private String gcubeAccessType;
    private String serviceClass;

    public ServiceEngine(String[] server) {
        this.server = server;
    }

    public ServiceEngine(String[] server, String clientId, String serviceClass, String serviceName, String env, String scope, String owner) {
        String id = clientId + "_" + serviceClass + "_" + serviceName;
        this.server = server;
        this.owner = owner;
        this.setEnvironment(env);
        this.setScope(scope);
        this.setPublicArea(FILE_SEPARATOR + env + FILE_SEPARATOR + "public" + FILE_SEPARATOR);
        this.setHomeArea(FILE_SEPARATOR + env + FILE_SEPARATOR + "home" + FILE_SEPARATOR + id + FILE_SEPARATOR);
    }

    public ServiceEngine(String[] server, String id, String environment, String scope, String owner) {
        this.server = server;
        this.owner = owner;
        this.setEnvironment(environment);
        this.scope = scope.equals("public") ? scope : DEFAULT_SCOPE;
        this.setPublicArea(FILE_SEPARATOR + environment + FILE_SEPARATOR + "public" + FILE_SEPARATOR);
        this.setHomeArea(FILE_SEPARATOR + environment + FILE_SEPARATOR + "home" + FILE_SEPARATOR + id + FILE_SEPARATOR);
    }

    public ServiceEngine(String[] server, String clientId, String env) {
        this.server = server;
        this.owner = clientId;
        this.setHomeArea(FILE_SEPARATOR + env + FILE_SEPARATOR + "home" + FILE_SEPARATOR + clientId + FILE_SEPARATOR);
    }

    public String getPublicArea() {
        return this.publicArea;
    }

    public void setPublicArea(String publicArea) {
        this.publicArea = publicArea;
    }

    public String getHomeArea() {
        return this.homeArea;
    }

    public void setHomeArea(String rootPath) {
        this.homeArea = rootPath;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getBucketID() {
        return this.bucketID;
    }

    public void setBucketID(String bucketID) {
        this.bucketID = bucketID;
    }

    @Deprecated
    public IClient bucketName(String bucketName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("bucketName(String) - start");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("bucketName(String) - TerrastoreServiec set bucketName: " + bucketName);
        }
        this.setBucketID(bucketName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("bucketName(String) - end");
        }
        return this;
    }

    protected MyFile extractProperties(String path, String type) {
        if (type.equalsIgnoreCase("remote")) {
            path = new BucketCoding().mergingPathAndFile(this.getContext(), path);
        }
        String[] dirs = path.split(FILE_SEPARATOR);
        String name = dirs[dirs.length - 1];
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("path(String) - name: " + name);
        }
        if (this.file == null) {
            this.file = new MyFile(name);
        } else {
            this.file.setName(name);
        }
        this.file.setOwner(this.owner);
        String dir = path.substring(0, path.length() - name.length());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("path(String) - path: " + dir);
        }
        if (type.equalsIgnoreCase("local")) {
            if (this.file.getLocalDir() == null) {
                this.file.setLocalDir(dir);
            }
        } else if (this.file.getRemoteDir() == null) {
            this.file.setRemoteDir(dir);
        }
        return this.file;
    }

    @Override
    public LocalResource get() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get() - start");
        }
        this.setCurrentOperation("download");
        this.service = new OperationManager(this.server, this.getCurrentOperation(), this.file);
        return new LocalResource(this.file, this);
    }

    @Override
    public RemoteResourceInfo getSize() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("get() - start");
        }
        this.setCurrentOperation("getSize");
        this.service = new OperationManager(this.server, this.getCurrentOperation(), this.file);
        return new RemoteResourceInfo(this.file, this);
    }

    @Override
    public LocalResource put(boolean replace) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put() - start");
        }
        Object bucketName = null;
        this.setCurrentOperation("upload");
        this.setReplaceOption(replace);
        this.service = new OperationManager(this.server, this.getCurrentOperation(), this.getMyFile());
        Object bucket = null;
        return new LocalResource(this.file, this);
    }

    @Override
    public RemoteResource remove() {
        if (this.file == null) {
            this.file = new MyFile();
        }
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.setCurrentOperation("remove");
        this.service = new OperationManager(this.server, this.getCurrentOperation(), this.file);
        return new RemoteResource(this.file, this);
    }

    public MyFile getMyFile() {
        return this.file;
    }

    public void setMyFile(MyFile myFile) {
        this.file = myFile;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @Override
    public RemoteResource showDir() {
        if (this.file == null) {
            this.file = new MyFile();
        }
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.setCurrentOperation("showDir");
        return new RemoteResource(this.file, this);
    }

    List addObjectsDirBucket(Map<String, DirectoryEntity> mapDirs) {
        Set<String> dirsKeys = mapDirs.keySet();
        ArrayList<DirectoryEntity> dirs = new ArrayList<DirectoryEntity>(dirsKeys.size());
        for (String key : dirsKeys) {
            key = new BucketCoding().bucketDirDecoding(key, this.getContext());
            this.logger.info("add " + key);
            dirs.add(mapDirs.get(key));
        }
        return dirs;
    }

    @Override
    public RemoteResource removeDir() {
        if (this.file == null) {
            this.file = new MyFile();
        }
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.setCurrentOperation("removedir");
        return new RemoteResource(this.file, this);
    }

    @Override
    public RemoteResource getUrl() {
        if (this.file == null) {
            this.file = new MyFile();
        }
        this.file.setGcubeAccessType(this.getGcubeAccessType());
        this.file.setGcubeScope(this.getGcubeScope());
        this.file.setOwnerGcube(this.getOwnerGcube());
        this.file.setServiceName(this.getServiceName());
        this.file.setServiceClass(this.getServiceClass());
        this.setCurrentOperation("getUrl");
        this.service = new OperationManager(this.server, this.getCurrentOperation(), this.file);
        RemoteResource resource = new RemoteResource(this.file, this);
        return resource;
    }

    @Deprecated
    public String searchByName(String name) {
        String matched = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Search in the bucket's directory with owner: " + this.owner + " the file named: " + name);
        }
        String rootPath = this.getContext().replaceAll(FILE_SEPARATOR, "_-_");
        TransportManagerFactory tmf = new TransportManagerFactory(this.server);
        TransportManager tm = tmf.getTransport("mongo");
        DirectoryBucket dir = new DirectoryBucket(this.server, name, this.owner);
        matched = dir.searchInBucket(name, rootPath, tm, this.getHomeArea());
        return matched;
    }

    @Deprecated
    public IClient setAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, value);
        return this;
    }

    public String getContext() {
        if (this.isPublic()) {
            return this.getPublicArea();
        }
        return this.getHomeArea();
    }

    public boolean isPublic() {
        if (this.getScope() != null) {
            return this.getScope().equalsIgnoreCase("public");
        }
        return DEFAULT_SCOPE.equalsIgnoreCase("public");
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (!(scope.equalsIgnoreCase("public") || scope.equalsIgnoreCase(DEFAULT_SCOPE) || scope.equalsIgnoreCase("group"))) {
            throw new IllegalArgumentException("bad scope usage: public | group | private ");
        }
        this.scope = scope;
    }

    public String getCurrentOperation() {
        return this.currentOperation;
    }

    public void setCurrentOperation(String currentOperation) {
        this.currentOperation = currentOperation;
    }

    public boolean isReplaceOption() {
        return this.replaceOption;
    }

    public void setReplaceOption(boolean replaceOption) {
        this.replaceOption = replaceOption;
    }

    @Override
    public RemoteResource lock() {
        this.file = new MyFile(true);
        this.setCurrentOperation("lock");
        this.service = new OperationManager(this.server, this.getCurrentOperation(), this.file);
        return new RemoteResource(this.file, this);
    }

    @Override
    public RemoteResource unlock(String key) {
        this.file = new MyFile();
        this.file.setLockedKey(key);
        this.setCurrentOperation("unlock");
        this.service = new OperationManager(this.server, this.getCurrentOperation(), this.file);
        return new RemoteResource(this.file, this);
    }

    @Override
    public RemoteResourceInfo getTTL() {
        this.file = new MyFile();
        this.setCurrentOperation("getTTL");
        this.service = new OperationManager(this.server, this.getCurrentOperation(), this.file);
        return new RemoteResourceInfo(this.file, this);
    }

    @Override
    public RemoteResourceInfo renewTTL(String key) {
        this.file = new MyFile();
        this.file.setLockedKey(key);
        this.setCurrentOperation("renewTTL");
        this.service = new OperationManager(this.server, this.getCurrentOperation(), this.file);
        return new RemoteResourceInfo(this.file, this);
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getOwnerGcube() {
        return this.ownerGcube;
    }

    public void setOwnerGcube(String ownerGcube) {
        this.ownerGcube = ownerGcube;
    }

    public String getGcubeScope() {
        return this.gcubeScope;
    }

    public void setGcubeScope(String gcubeScope) {
        this.gcubeScope = gcubeScope;
    }

    public String getGcubeAccessType() {
        return this.gcubeAccessType;
    }

    public void setGcubeAccessType(String gcubeAccessType) {
        this.gcubeAccessType = gcubeAccessType;
    }
}

