/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.impl.Resource;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;

public class RemoteResourceInfo
extends Resource {
    private String serviceName;
    private String serviceClass;
    private String ownerGcube;
    private String gcubeScope;
    private String gcubeAccessType;

    public RemoteResourceInfo(MyFile file, ServiceEngine engine) {
        super(file, engine);
    }

    public long RFile(String path) {
        this.file = this.extractProperties(this.engine.getContext(), this.engine.owner, path, "remote");
        this.file.setPathServer(path);
        this.file.setOwner(this.engine.owner);
        this.setMyFile(this.file);
        this.engine.service.setResource(this.getMyFile());
        Object info = null;
        try {
            if (this.file.getInputStream() == null && (this.file.getPathClient() != null || this.file.getPathServer() != null)) {
                info = this.engine.service.startOperation(this.file, this.file.getPathServer(), this.engine.owner, this.engine.server, false, this.engine.getContext(), this.engine.isReplaceOption());
            } else if (this.file.getInputStream() != null || this.file.getOutputStream() != null) {
                info = this.engine.service.startOperation(this.file, this.file.getPathServer(), this.engine.owner, this.engine.server, false, this.engine.getContext());
            } else {
                this.logger.error("parameters incompatible ");
            }
        }
        catch (Exception e) {
            this.logger.error("get()", (Throwable)e);
        }
        if (info != null) {
            return Long.parseLong(info.toString());
        }
        return -1L;
    }

    public long RFileById(String id) {
        this.engine.service.setResource(this.getMyFile());
        Object info = null;
        try {
            if (!this.engine.getCurrentOperation().equalsIgnoreCase("download")) {
                throw new IllegalArgumentException("Input Parameters incompatible");
            }
            info = this.engine.service.startOperation(this.getMyFile(), id, this.engine.owner, this.engine.server, false, "", this.engine.isReplaceOption());
        }
        catch (Exception e) {
            this.logger.error("get()", (Throwable)e);
        }
        if (info != null) {
            return Long.parseLong(info.toString());
        }
        return -1L;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getOwnerGcube() {
        return this.ownerGcube;
    }

    public void setOwnerGcube(String ownerGcube) {
        this.ownerGcube = ownerGcube;
    }

    public String getGcubeScope() {
        return this.gcubeScope;
    }

    public void setGcubeScope(String gcubeScope) {
        this.gcubeScope = gcubeScope;
    }

    public String getGcubeAccessType() {
        return this.gcubeAccessType;
    }

    public void setGcubeAccessType(String gcubeAccessType) {
        this.gcubeAccessType = gcubeAccessType;
    }

    public void getServiceClass(String serviceClass) {
    }
}

