/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import com.mongodb.MongoException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryBucket;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryEntity;
import org.gcube.contentmanagement.blobstorage.service.impl.Resource;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;

public class RemoteResource
extends Resource {
    public RemoteResource(MyFile file, ServiceEngine engine) {
        super(file, engine);
        this.logger.info("file gCube parameter costructor: " + file.getGcubeAccessType() + " " + file.getGcubeScope());
    }

    public String RFile(String path) {
        this.logger.info("file gCube parameter before: " + this.file.getGcubeAccessType() + " " + this.file.getGcubeScope());
        this.file = this.extractProperties(this.engine.getContext(), this.engine.owner, path, "remote");
        this.file.setPathServer(path);
        this.file.setOwner(this.engine.owner);
        this.setMyFile(this.file);
        this.engine.service.setResource(this.getMyFile());
        String bucketName = null;
        this.logger.info("file gCube parameter after: " + this.file.getGcubeAccessType() + " " + this.file.getGcubeScope());
        try {
            if (this.file.getInputStream() == null && (this.file.getPathClient() != null || this.file.getPathServer() != null)) {
                bucketName = (String)this.engine.service.startOperation(this.file, this.file.getPathServer(), this.engine.owner, this.engine.server, false, this.engine.getContext(), this.engine.isReplaceOption());
            } else if (this.file.getInputStream() != null || this.file.getOutputStream() != null) {
                bucketName = (String)this.engine.service.startOperation(this.file, this.file.getPathServer(), this.engine.owner, this.engine.server, false, this.engine.getContext());
            } else {
                this.logger.error("parameters incompatible ");
            }
        }
        catch (Exception e) {
            this.logger.error("get()", (Throwable)e);
        }
        return bucketName;
    }

    public String RFileById(String id) {
        this.engine.service.setResource(this.getMyFile());
        String bucketName = null;
        try {
            if (!(this.engine.getCurrentOperation().equalsIgnoreCase("download") || this.engine.getCurrentOperation().equalsIgnoreCase("remove") || this.engine.getCurrentOperation().equalsIgnoreCase("unlock") || this.engine.getCurrentOperation().equalsIgnoreCase("lock"))) {
                throw new IllegalArgumentException("Input Parameters incompatible");
            }
            bucketName = (String)this.engine.service.startOperation(this.getMyFile(), id, this.engine.owner, this.engine.server, false, "", this.engine.isReplaceOption());
        }
        catch (Exception e) {
            this.logger.error("get()", (Throwable)e);
        }
        return bucketName;
    }

    public List<StorageObject> RDir(String dir) {
        if (this.engine.getCurrentOperation().equalsIgnoreCase("showdir")) {
            dir = new BucketCoding().bucketDirCoding(this.engine.owner, dir, this.engine.getContext());
            TransportManagerFactory tmf = new TransportManagerFactory(this.engine.server);
            TransportManager tm = tmf.getTransport("mongo");
            Map mapDirs = null;
            try {
                mapDirs = tm.getValues(dir, DirectoryEntity.class);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            catch (MongoException e) {
                e.printStackTrace();
            }
            List dirs = null;
            if (mapDirs != null) {
                dirs = this.engine.addObjectsDirBucket(mapDirs);
            }
            if (dirs == null) {
                dirs = Collections.emptyList();
            }
            return dirs;
        }
        if (this.engine.getCurrentOperation().equalsIgnoreCase("removedir")) {
            if (dir != null && this.engine.owner != null) {
                DirectoryBucket dirBuc = new DirectoryBucket(this.engine.server, dir, this.engine.owner);
                String bucketName = null;
                if (!"mongo".equalsIgnoreCase("mongo")) {
                    bucketName = dirBuc.removeDirBucket(dir, this.engine.getContext());
                } else {
                    TransportManagerFactory tmf = new TransportManagerFactory(this.engine.server);
                    TransportManager tm = tmf.getTransport("mongo");
                    dir = new BucketCoding().mergingPathAndFile(this.engine.getContext(), dir);
                    try {
                        tm.removeDir(dir);
                    }
                    catch (UnknownHostException e) {
                        e.printStackTrace();
                    }
                    catch (MongoException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                this.logger.error("REMOVE Operation not valid:\n\t specify a valid bucketID or an author and a path on the cluster ");
            }
            return null;
        }
        throw new IllegalArgumentException("The method RDir is not applicable for the operation selected");
    }
}

