/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.streaming;

import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.streaming.DumpTypedBytes;
import org.apache.hadoop.streaming.LoadTypedBytes;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class HadoopStreaming {
    private static Logger LOGGER = Logger.getLogger(HadoopStreaming.class);

    public static int doRun(Configuration config, String[] args) throws Exception {
        if (args.length < 1) {
            LOGGER.error((Object)"No Arguments Given!");
            return 1;
        }
        int returnStatus = 0;
        String cmd = args[0];
        String[] remainingArgs = Arrays.copyOfRange(args, 1, args.length);
        if (cmd.equalsIgnoreCase("dumptb")) {
            DumpTypedBytes dumptb = new DumpTypedBytes();
            returnStatus = ToolRunner.run((Tool)dumptb, (String[])remainingArgs);
        } else if (cmd.equalsIgnoreCase("loadtb")) {
            LoadTypedBytes loadtb = new LoadTypedBytes();
            returnStatus = ToolRunner.run((Tool)loadtb, (String[])remainingArgs);
        } else if (cmd.equalsIgnoreCase("streamjob")) {
            StreamJob job = new StreamJob();
            returnStatus = ToolRunner.run((Tool)job, (String[])remainingArgs);
        } else {
            StreamJob job = new StreamJob();
            returnStatus = ToolRunner.run((Configuration)config, (Tool)job, (String[])args);
        }
        return returnStatus;
    }

    public static String getErrorCodes(int ErrorCode) {
        switch (ErrorCode) {
            case 1: {
                return "Job not Successful!";
            }
            case 2: {
                return "Error launching job , bad input path";
            }
            case 3: {
                return "Error launching job , Invalid job conf";
            }
            case 4: {
                return "Error launching job , Output path already exists";
            }
            case 5: {
                return "Error launching job";
            }
        }
        return "Error code not recognized";
    }
}

