/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.directory;

import java.io.IOException;
import java.util.List;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureLock;
import org.geotools.data.LockingManager;
import org.geotools.data.Transaction;
import org.geotools.data.directory.DirectoryTypeCache;

public class DirectoryLockingManager
implements LockingManager {
    DirectoryTypeCache cache;

    public DirectoryLockingManager(DirectoryTypeCache cache) {
        this.cache = cache;
    }

    public boolean exists(String authID) {
        List<DataStore> stores = this.cache.getDataStores();
        for (DataStore store : stores) {
            if (store.getLockingManager() == null || !store.getLockingManager().exists(authID)) continue;
            return true;
        }
        return false;
    }

    public boolean release(String authID, Transaction transaction) throws IOException {
        List<DataStore> stores = this.cache.getDataStores();
        for (DataStore store : stores) {
            if (store.getLockingManager() == null || !store.getLockingManager().exists(authID)) continue;
            return store.getLockingManager().release(authID, transaction);
        }
        return false;
    }

    public boolean refresh(String authID, Transaction transaction) throws IOException {
        List<DataStore> stores = this.cache.getDataStores();
        for (DataStore store : stores) {
            if (store.getLockingManager() == null || !store.getLockingManager().exists(authID)) continue;
            return store.getLockingManager().refresh(authID, transaction);
        }
        return false;
    }

    public void unLockFeatureID(String typeName, String authID, Transaction transaction, FeatureLock featureLock) throws IOException {
        DataStore store = this.cache.getDataStore(typeName, false);
        if (store != null && store.getLockingManager() != null) {
            store.getLockingManager().unLockFeatureID(typeName, authID, transaction, featureLock);
        }
    }

    public void lockFeatureID(String typeName, String authID, Transaction transaction, FeatureLock featureLock) throws IOException {
        DataStore store = this.cache.getDataStore(typeName, false);
        if (store != null && store.getLockingManager() != null) {
            store.getLockingManager().lockFeatureID(typeName, authID, transaction, featureLock);
        }
    }
}

