/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.client.demo;

import com.terradue.wps_hadoop.client.ExecuteRequestBuilder;
import com.terradue.wps_hadoop.client.ExecuteResponseAnalyser;
import java.io.IOException;
import java.util.HashMap;
import net.opengis.wps.x100.CapabilitiesDocument;
import net.opengis.wps.x100.ExecuteDocument;
import net.opengis.wps.x100.ExecuteResponseDocument;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.ProcessBriefType;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.geotools.feature.FeatureCollection;
import org.n52.wps.client.WPSClientException;
import org.n52.wps.client.WPSClientSession;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class testWPSClientIntersection {
    public void testExecute() {
        String wpsURL = "http://10.11.30.97:8888/wps/WebProcessingService";
        String processID = "com.terradue.wps_hadoop.examples.intersection.IntersectionHadoopAlgorithm";
        try {
            ProcessDescriptionType describeProcessDocument = this.requestDescribeProcess(wpsURL, processID);
            System.out.println(describeProcessDocument);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            CapabilitiesDocument capabilitiesDocument = this.requestGetCapabilities(wpsURL);
            ProcessDescriptionType describeProcessDocument = this.requestDescribeProcess(wpsURL, processID);
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            inputs.put("Polygon1", "http://www.fao.org/figis/geoserver/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=fifao:FAO_MAJOR&CQL_FILTER=fifao:F_AREA=21");
            inputs.put("Polygon2", "http://geo.vliz.be/geoserver/Marbound/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=Marbound:eez&CQL_FILTER%3DINTERSECTS(Marbound%3Athe_geom%2CPOLYGON((-82.410003662+34.830001831%2C-42+34.830001831%2C-42+78.166666031%2C-82.410003662+78.166666031%2C-82.410003662+34.830001831)))");
            ExecuteResponseAnalyser analyser = this.executeProcess(wpsURL, processID, describeProcessDocument, inputs);
            System.out.println(analyser.getRawResponseDocument().toString());
            IData data = analyser.getComplexDataByIndex(0, GTVectorDataBinding.class);
            if (data == null) {
                data = new LiteralStringBinding(analyser.getLiteralDataByIndex(0).getStringValue());
                System.out.println("result " + data.getPayload());
            }
        }
        catch (WPSClientException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CapabilitiesDocument requestGetCapabilities(String url) throws WPSClientException {
        ProcessBriefType[] processList;
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        wpsClient.connect(url);
        CapabilitiesDocument capabilities = wpsClient.getWPSCaps(url);
        for (ProcessBriefType process : processList = capabilities.getCapabilities().getProcessOfferings().getProcessArray()) {
            System.out.println(process.getIdentifier().getStringValue());
        }
        return capabilities;
    }

    public ProcessDescriptionType requestDescribeProcess(String url, String processID) throws IOException {
        InputDescriptionType[] inputList;
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        ProcessDescriptionType processDescription = wpsClient.getProcessDescription(url, processID);
        for (InputDescriptionType input : inputList = processDescription.getDataInputs().getInputArray()) {
            System.out.println(input.getIdentifier().getStringValue());
        }
        return processDescription;
    }

    public ExecuteResponseAnalyser executeProcess(String url, String processID, ProcessDescriptionType processDescription, HashMap<String, Object> inputs) throws Exception {
        ExecuteRequestBuilder executeBuilder = new ExecuteRequestBuilder(processDescription);
        for (InputDescriptionType input : processDescription.getDataInputs().getInputArray()) {
            String inputName = input.getIdentifier().getStringValue();
            Object inputValue = inputs.get(inputName);
            if (input.getLiteralData() != null) {
                if (!(inputValue instanceof String)) continue;
                executeBuilder.addLiteralData(inputName, (String)inputValue);
                continue;
            }
            if (input.getComplexData() == null) continue;
            if (inputValue instanceof FeatureCollection) {
                GTVectorDataBinding data = new GTVectorDataBinding((FeatureCollection)inputValue);
                executeBuilder.addComplexData(inputName, (IData)data, "http://schemas.opengis.net/gml/3.1.1/base/feature.xsd", "UTF-8", "text/xml");
            }
            if (inputValue instanceof String) {
                executeBuilder.addComplexDataReference(inputName, (String)inputValue, "http://schemas.opengis.net/gml/3.1.1/base/feature.xsd", "UTF-8", "text/xml");
            }
            if (inputValue != null || input.getMinOccurs().intValue() <= 0) continue;
            throw new IOException("Property not set, but mandatory: " + inputName);
        }
        executeBuilder.setMimeTypeForOutput("text/xml", "result");
        executeBuilder.setSchemaForOutput("http://schemas.opengis.net/gml/3.1.1/base/feature.xsd", "result");
        ExecuteDocument execute = executeBuilder.getExecute();
        execute.getExecute().setService("WPS");
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        Object responseObject = wpsClient.execute(url, execute);
        if (responseObject instanceof ExecuteResponseDocument) {
            ExecuteResponseDocument response = (ExecuteResponseDocument)responseObject;
            ExecuteResponseAnalyser analyser = new ExecuteResponseAnalyser(execute, response, processDescription);
            IData data = analyser.getComplexDataByIndex(0, GTVectorDataBinding.class);
            return analyser;
        }
        throw new Exception("Exception: " + responseObject.toString());
    }

    public static void main(String[] args) {
        testWPSClientIntersection client = new testWPSClientIntersection();
        client.testExecute();
    }
}

