/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollections;
import org.geotools.feature.FeatureCollection;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.xml.sax.SAXException;

public class GML2BasicParser
extends AbstractParser {
    private static Logger LOGGER = Logger.getLogger(GML2BasicParser.class);

    public GML2BasicParser() {
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
    }

    @Override
    public GTVectorDataBinding parse(InputStream stream, String mimeType, String schema) {
        GMLConfiguration configuration = new GMLConfiguration();
        Parser parser = new Parser((Configuration)configuration);
        SimpleFeatureCollection fc = DefaultFeatureCollections.newCollection();
        try {
            Object parsedData = parser.parse(stream);
            if (parsedData instanceof FeatureCollection) {
                fc = (FeatureCollection)parsedData;
            } else if (parsedData instanceof HashMap) {
                if (((HashMap)parsedData).get("featureMember") instanceof SimpleFeature) {
                    SimpleFeature feature = (SimpleFeature)((HashMap)parsedData).get("featureMember");
                    fc.add((Feature)feature);
                } else if (((HashMap)parsedData).get("featureMember") instanceof List) {
                    ArrayList featureList = (ArrayList)((HashMap)parsedData).get("featureMember");
                    for (SimpleFeature feature : featureList) {
                        fc.add((Feature)feature);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        GTVectorDataBinding data = new GTVectorDataBinding((FeatureCollection)fc);
        return data;
    }
}

