/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.DataSourceException;
import org.geotools.gce.arcgrid.ArcGridWriter;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTRasterDataBinding;
import org.n52.wps.io.datahandler.generator.AbstractGenerator;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public class AsciiGrassGenerator
extends AbstractGenerator {
    private static Logger LOGGER = Logger.getLogger(AsciiGrassGenerator.class);

    public AsciiGrassGenerator() {
        this.supportedIDataTypes.add(GTRasterDataBinding.class);
    }

    @Override
    public InputStream generateStream(IData data, String mimeType, String schema) throws IOException {
        FileInputStream stream = null;
        GridCoverage2D grid = ((GTRasterDataBinding)data).getPayload();
        String fileName = "temp" + UUID.randomUUID() + ".tmp";
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        File outputFile = new File(tmpDirPath + File.pathSeparatorChar + fileName);
        this.finalizeFiles.add(outputFile);
        try {
            ArcGridWriter writer = new ArcGridWriter((Object)outputFile);
            ParameterValueGroup params = writer.getFormat().getWriteParameters();
            params.parameter("GRASS").setValue(true);
            GeneralParameterValue[] gpv = new GeneralParameterValue[]{params.parameter("GRASS")};
            writer.write((GridCoverage)grid, gpv);
            writer.dispose();
            stream = new FileInputStream(outputFile);
        }
        catch (DataSourceException e) {
            LOGGER.error((Object)e.getMessage());
            throw new IOException("AsciiGRID cannot be read from source");
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)e.getMessage());
            throw new IOException("Illegal configuration of AsciiGRID writer");
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage());
            throw new IOException("AsciiGrassGenerator could not create output due to an IO error");
        }
        return stream;
    }
}

