/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64InputStream;
import org.n52.wps.FormatDocument;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.io.AbstractIOHandler;
import org.n52.wps.io.IGenerator;
import org.n52.wps.io.data.IData;

public abstract class AbstractGenerator
extends AbstractIOHandler
implements IGenerator {
    protected List<File> finalizeFiles;

    public AbstractGenerator() {
        this.properties = WPSConfig.getInstance().getPropertiesForGeneratorClass(this.getClass().getName());
        for (FormatDocument.Format format : this.formats = WPSConfig.getInstance().getFormatsForGeneratorClass(this.getClass().getName())) {
            if (format.getMimetype() != null && !format.getMimetype().equals("")) {
                String mimetype = format.getMimetype();
                this.supportedFormats.add(mimetype);
            }
            if (format.getSchema() != null && !format.getSchema().equals("")) {
                String schema = format.getSchema();
                this.supportedSchemas.add(schema);
            }
            if (format.getEncoding() != null && !format.getEncoding().equals("")) {
                String encoding = format.getEncoding();
                this.supportedEncodings.add(encoding);
                continue;
            }
            this.supportedEncodings.add("UTF-8");
        }
        this.finalizeFiles = new ArrayList<File>();
    }

    @Override
    public InputStream generateBase64Stream(IData data, String mimeType, String schema) throws IOException {
        return new Base64InputStream(this.generateStream(data, mimeType, schema), true);
    }

    protected void finalize() throws Throwable {
        for (File currentFile : this.finalizeFiles) {
            currentFile.delete();
        }
        super.finalize();
    }
}

