/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.nature;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;

public final class Calendar {
    private static double MILLIS_IN_DAY = 8.64E7;
    private static double JULIAN_DAY_1970 = 2440587.5;

    private Calendar() {
    }

    public static double julianDay(Date time) {
        return Calendar.julianDay(time.getTime());
    }

    static double julianDay(long time) {
        return (double)time / MILLIS_IN_DAY + JULIAN_DAY_1970;
    }

    static double julianCentury(Date time) {
        return ((double)time.getTime() / MILLIS_IN_DAY + (JULIAN_DAY_1970 - 2451545.0)) / 36525.0;
    }

    public static double tropicalYearLength(Date time) {
        double T = Calendar.julianCentury(time);
        return 365.2421896698 + T * (-6.15359E-6 + T * (-7.29E-10 + T * 2.64E-10));
    }

    public static double synodicMonthLength(Date time) {
        double T = Calendar.julianCentury(time);
        return 29.5305888531 + T * (2.1621E-7 + T * -3.64E-10);
    }

    public static final void main(String[] args) throws ParseException {
        DateFormat format = DateFormat.getDateInstance(3);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date time = args.length != 0 ? format.parse(args[0]) : new Date();
        System.out.print("Date (UTC)   : ");
        System.out.println(format.format(time));
        System.out.print("Tropical year: ");
        System.out.println(Calendar.tropicalYearLength(time));
        System.out.print("Synodic month: ");
        System.out.println(Calendar.synodicMonthLength(time));
    }
}

