/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.VolatileFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterAttributeExtractor
extends DefaultFilterVisitor {
    protected Set<String> attributeNames = new HashSet<String>();
    protected Set<PropertyName> propertyNames = new HashSet<PropertyName>();
    protected boolean usingVolatileFunctions;
    protected SimpleFeatureType featureType;

    public FilterAttributeExtractor() {
        this(null);
    }

    public FilterAttributeExtractor(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public Set<String> getAttributeNameSet() {
        return Collections.unmodifiableSet(this.attributeNames);
    }

    public String[] getAttributeNames() {
        return this.attributeNames.toArray(new String[this.attributeNames.size()]);
    }

    public void clear() {
        this.attributeNames = new HashSet<String>();
        this.usingVolatileFunctions = false;
    }

    @Override
    public Object visit(PropertyName expression, Object data) {
        if (data != null && data != this.attributeNames) {
            this.attributeNames = (Set)data;
        }
        if (this.featureType != null) {
            AttributeDescriptor type = (AttributeDescriptor)expression.evaluate((Object)this.featureType);
            if (type != null) {
                this.attributeNames.add(type.getLocalName());
            } else {
                this.attributeNames.add(expression.getPropertyName());
            }
        } else {
            this.attributeNames.add(expression.getPropertyName());
        }
        return this.attributeNames;
    }

    @Override
    public Object visit(Function expression, Object data) {
        if (expression instanceof VolatileFunction) {
            this.usingVolatileFunctions = true;
        }
        return super.visit(expression, data);
    }

    public boolean isConstantExpression() {
        return !this.usingVolatileFunctions && this.getAttributeNameSet().isEmpty();
    }
}

