/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.io;

import java.lang.reflect.Array;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Locale;
import org.geotools.resources.ClassChanger;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;

public class LineFormat
extends Format {
    private static final long serialVersionUID = 1663380990689494113L;
    private int count;
    private Object[] data;
    private final Format[] format;
    private final ParsePosition position = new ParsePosition(0);
    private int[] limits;
    private String line;

    public LineFormat() {
        this(NumberFormat.getNumberInstance());
    }

    public LineFormat(Locale locale) {
        this(NumberFormat.getNumberInstance(locale));
    }

    public LineFormat(Format format) throws IllegalArgumentException {
        this.data = new Object[16];
        this.limits = new int[this.data.length + 1];
        this.format = new Format[]{format};
        if (format == null) {
            Integer one = 1;
            throw new IllegalArgumentException(Errors.format(145, one, one));
        }
    }

    public LineFormat(Format[] formats) throws IllegalArgumentException {
        this.data = new Object[formats.length];
        this.format = new Format[formats.length];
        this.limits = new int[formats.length + 1];
        System.arraycopy(formats, 0, this.format, 0, formats.length);
        for (int i = 0; i < this.format.length; ++i) {
            if (this.format[i] != null) continue;
            throw new IllegalArgumentException(Errors.format(145, i + 1, this.format.length));
        }
    }

    public void clear() {
        this.line = null;
        Arrays.fill(this.data, null);
        this.count = 0;
    }

    public int setLine(String line) throws ParseException {
        return this.setLine(line, 0, line.length());
    }

    public int setLine(String line, int lower, int upper) throws ParseException {
        this.line = line;
        Arrays.fill(this.data, null);
        this.count = 0;
        while (lower < upper) {
            if (Character.isWhitespace(line.charAt(lower))) {
                ++lower;
                continue;
            }
            this.position.setIndex(lower);
            Object datum = this.format[Math.min(this.count, this.format.length - 1)].parseObject(line, this.position);
            int next = this.position.getIndex();
            if (datum == null || next <= lower) {
                int error;
                int end;
                for (end = error = this.position.getErrorIndex(); end < upper && !Character.isWhitespace(line.charAt(end)); ++end) {
                }
                throw new ParseException(Errors.format(155, line.substring(lower, end).trim(), line.substring(error, Math.min(error + 1, end))), error);
            }
            if (this.count >= this.data.length) {
                this.data = XArray.resize(this.data, this.count + Math.min(this.count, 256));
                this.limits = XArray.resize(this.limits, this.data.length + 1);
            }
            this.limits[this.count] = lower;
            this.data[this.count++] = datum;
            lower = next;
        }
        this.limits[this.count] = lower;
        return this.count;
    }

    public int getValueCount() {
        return this.count;
    }

    public void setValues(Object values) throws IllegalArgumentException {
        int length = Array.getLength(values);
        this.data = XArray.resize(this.data, length);
        for (int i = 0; i < length; ++i) {
            this.data[i] = Array.get(values, i);
        }
        this.count = length;
    }

    public void setValue(int index, Object value) throws ArrayIndexOutOfBoundsException {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (value == null) {
            throw new IllegalArgumentException(Errors.format(143, "value"));
        }
        if (index == this.count) {
            if (index == this.data.length) {
                this.data = XArray.resize(this.data, index + Math.min(index, 256));
            }
            ++this.count;
        }
        this.data[index] = value;
    }

    public Object getValue(int index) throws ArrayIndexOutOfBoundsException {
        if (index < this.count) {
            return this.data[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    private Object getValues() {
        Object[] values = new Object[this.count];
        System.arraycopy(this.data, 0, values, 0, this.count);
        return values;
    }

    private Number getNumber(int index) throws ParseException {
        ClassNotFoundException error = null;
        if (this.data[index] instanceof Comparable) {
            try {
                return ClassChanger.toNumber((Comparable)this.data[index]);
            }
            catch (ClassNotFoundException exception) {
                error = exception;
            }
        }
        ParseException exception = new ParseException(Errors.format(191, this.data[index]), this.limits[index]);
        if (error != null) {
            exception.initCause(error);
        }
        throw exception;
    }

    public double[] getValues(double[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new double[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            array[i] = this.getNumber(i).doubleValue();
        }
        return array;
    }

    public float[] getValues(float[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new float[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            array[i] = this.getNumber(i).floatValue();
        }
        return array;
    }

    public long[] getValues(long[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new long[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number n = this.getNumber(i);
            array[i] = n.longValue();
            if ((double)array[i] == n.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return array;
    }

    public int[] getValues(int[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new int[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number n = this.getNumber(i);
            array[i] = n.intValue();
            if ((double)array[i] == n.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return array;
    }

    public short[] getValues(short[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new short[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number n = this.getNumber(i);
            array[i] = n.shortValue();
            if ((double)array[i] == n.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return array;
    }

    public byte[] getValues(byte[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new byte[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number n = this.getNumber(i);
            array[i] = n.byteValue();
            if ((double)array[i] == n.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return array;
    }

    private void checkLength(int expected) throws ParseException {
        if (this.count != expected) {
            int lower = this.limits[Math.min(this.count, expected)];
            int upper = this.limits[Math.min(this.count, expected + 1)];
            throw new ParseException(Errors.format(this.count < expected ? 87 : 86, this.count, expected, this.line.substring(lower, upper).trim()), lower);
        }
    }

    private ParseException notAnInteger(int i) {
        return new ParseException(Errors.format(120, this.line.substring(this.limits[i], this.limits[i + 1])), this.limits[i]);
    }

    public String toString() {
        return this.toString(new StringBuffer()).toString();
    }

    private StringBuffer toString(StringBuffer buffer) {
        FieldPosition field = new FieldPosition(0);
        for (int i = 0; i < this.count; ++i) {
            if (i != 0) {
                buffer.append('\t');
            }
            buffer = this.format[Math.min(this.format.length - 1, i)].format(this.data[i], buffer, field);
        }
        return buffer;
    }

    public StringBuffer format(Object values, StringBuffer toAppendTo, FieldPosition position) {
        this.setValues(values);
        return this.toString(toAppendTo);
    }

    private static int getLineEnd(String source, int offset, boolean s) {
        char c;
        int length = source.length();
        while (offset < length && ((c = source.charAt(offset)) == '\r' || c == '\n') != s) {
            ++offset;
        }
        return offset;
    }

    public Object parseObject(String source, ParsePosition position) {
        int lower = position.getIndex();
        int upper = LineFormat.getLineEnd(source, lower, true);
        try {
            this.setLine(source.substring(lower, upper));
            position.setIndex(LineFormat.getLineEnd(source, upper, false));
            return this.getValues();
        }
        catch (ParseException e) {
            position.setErrorIndex(e.getErrorOffset());
            return null;
        }
    }

    public Object parseObject(String source) throws ParseException {
        this.setLine(source.substring(0, LineFormat.getLineEnd(source, 0, true)));
        return this.getValues();
    }

    public LineFormat clone() {
        LineFormat copy = (LineFormat)super.clone();
        copy.data = (Object[])this.data.clone();
        copy.limits = (int[])this.limits.clone();
        return copy;
    }
}

