/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;

public class OffsetCurveVertexList {
    private static final Coordinate[] COORDINATE_ARRAY_TYPE = new Coordinate[0];
    private ArrayList ptList = new ArrayList();
    private PrecisionModel precisionModel = null;
    private double minimimVertexDistance = 0.0;

    public void setPrecisionModel(PrecisionModel precisionModel) {
        this.precisionModel = precisionModel;
    }

    public void setMinimumVertexDistance(double minimimVertexDistance) {
        this.minimimVertexDistance = minimimVertexDistance;
    }

    public void addPt(Coordinate pt) {
        Coordinate bufPt = new Coordinate(pt);
        this.precisionModel.makePrecise(bufPt);
        if (this.isDuplicate(bufPt)) {
            return;
        }
        this.ptList.add(bufPt);
    }

    private boolean isDuplicate(Coordinate pt) {
        if (this.ptList.size() < 1) {
            return false;
        }
        Coordinate lastPt = (Coordinate)this.ptList.get(this.ptList.size() - 1);
        double ptDist = pt.distance(lastPt);
        return ptDist < this.minimimVertexDistance;
    }

    public void closeRing() {
        if (this.ptList.size() < 1) {
            return;
        }
        Coordinate startPt = new Coordinate((Coordinate)this.ptList.get(0));
        Coordinate lastPt = (Coordinate)this.ptList.get(this.ptList.size() - 1);
        Coordinate last2Pt = null;
        if (this.ptList.size() >= 2) {
            last2Pt = (Coordinate)this.ptList.get(this.ptList.size() - 2);
        }
        if (startPt.equals(lastPt)) {
            return;
        }
        this.ptList.add(startPt);
    }

    public Coordinate[] getCoordinates() {
        Coordinate end;
        Coordinate start;
        if (this.ptList.size() > 1 && !(start = (Coordinate)this.ptList.get(0)).equals(end = (Coordinate)this.ptList.get(this.ptList.size() - 1))) {
            this.addPt(start);
        }
        Coordinate[] coord = this.ptList.toArray(COORDINATE_ARRAY_TYPE);
        return coord;
    }

    public String toString() {
        GeometryFactory fact = new GeometryFactory();
        LineString line = fact.createLineString(this.getCoordinates());
        return line.toString();
    }
}

