/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.prep;

import com.vividsolutions.jts.algorithm.locate.PointOnGeometryLocator;
import com.vividsolutions.jts.algorithm.locate.SimplePointInAreaLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedPolygon;
import com.vividsolutions.jts.geom.util.ComponentCoordinateExtracter;
import java.util.Iterator;
import java.util.List;

public abstract class PreparedPolygonPredicate {
    protected PreparedPolygon prepPoly;
    private PointOnGeometryLocator targetPointLocator;

    public PreparedPolygonPredicate(PreparedPolygon prepPoly) {
        this.prepPoly = prepPoly;
        this.targetPointLocator = prepPoly.getPointLocator();
    }

    protected boolean isAllTestComponentsInTarget(Geometry testGeom) {
        List coords = ComponentCoordinateExtracter.getCoordinates(testGeom);
        Iterator i = coords.iterator();
        while (i.hasNext()) {
            Coordinate p = (Coordinate)i.next();
            int loc = this.targetPointLocator.locate(p);
            if (loc != 2) continue;
            return false;
        }
        return true;
    }

    protected boolean isAllTestComponentsInTargetInterior(Geometry testGeom) {
        List coords = ComponentCoordinateExtracter.getCoordinates(testGeom);
        Iterator i = coords.iterator();
        while (i.hasNext()) {
            Coordinate p = (Coordinate)i.next();
            int loc = this.targetPointLocator.locate(p);
            if (loc == 0) continue;
            return false;
        }
        return true;
    }

    protected boolean isAnyTestComponentInTarget(Geometry testGeom) {
        List coords = ComponentCoordinateExtracter.getCoordinates(testGeom);
        Iterator i = coords.iterator();
        while (i.hasNext()) {
            Coordinate p = (Coordinate)i.next();
            int loc = this.targetPointLocator.locate(p);
            if (loc == 2) continue;
            return true;
        }
        return false;
    }

    protected boolean isAnyTestComponentInTargetInterior(Geometry testGeom) {
        List coords = ComponentCoordinateExtracter.getCoordinates(testGeom);
        Iterator i = coords.iterator();
        while (i.hasNext()) {
            Coordinate p = (Coordinate)i.next();
            int loc = this.targetPointLocator.locate(p);
            if (loc != 0) continue;
            return true;
        }
        return false;
    }

    protected boolean isAnyTargetComponentInAreaTest(Geometry testGeom, List targetRepPts) {
        SimplePointInAreaLocator piaLoc = new SimplePointInAreaLocator(testGeom);
        Iterator i = targetRepPts.iterator();
        while (i.hasNext()) {
            Coordinate p = (Coordinate)i.next();
            int loc = piaLoc.locate(p);
            if (loc == 2) continue;
            return true;
        }
        return false;
    }
}

