/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.referencing.CRS;
import org.n52.wps.io.GTHelper;
import org.n52.wps.io.IOUtils;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GTBinZippedWKT64Parser
extends AbstractParser {
    public GTBinZippedWKT64Parser() {
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
    }

    @Override
    public GTVectorDataBinding parse(InputStream stream, String mimeType, String schema) {
        try {
            File zipped = IOUtils.writeBase64ToFile(stream, "zip");
            this.finalizeFiles.add(zipped);
            stream.close();
            List<File> wktFiles = IOUtils.unzip(zipped, "wkt");
            this.finalizeFiles.addAll(wktFiles);
            if (wktFiles == null) {
                throw new RuntimeException("Cannot find a shapefile inside the zipped file.");
            }
            ArrayList<Geometry> geometries = new ArrayList<Geometry>();
            for (int i = 0; i < wktFiles.size(); ++i) {
                File wktFile = wktFiles.get(i);
                FileReader fileReader = new FileReader(wktFile);
                WKTReader2 wktReader = new WKTReader2();
                Geometry geometry = wktReader.read((Reader)fileReader);
                geometries.add(geometry);
            }
            CoordinateReferenceSystem coordinateReferenceSystem = CRS.decode((String)"EPSG:4326");
            FeatureCollection inputFeatureCollection = this.createFeatureCollection(geometries, coordinateReferenceSystem);
            return new GTVectorDataBinding(inputFeatureCollection);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("An error has occurred while accessing provided data", e);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException("An error has occurred while accessing provided data", e);
        }
        catch (NoSuchAuthorityCodeException e) {
            e.printStackTrace();
            throw new RuntimeException("An error has occurred while accessing provided data", e);
        }
        catch (FactoryException e) {
            e.printStackTrace();
            throw new RuntimeException("An error has occurred while accessing provided data", e);
        }
    }

    private FeatureCollection createFeatureCollection(List<Geometry> geometries, CoordinateReferenceSystem coordinateReferenceSystem) {
        SimpleFeatureCollection collection = FeatureCollections.newCollection();
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        if (coordinateReferenceSystem == null) {
            try {
                coordinateReferenceSystem = CRS.decode((String)"EPSG:4326");
            }
            catch (NoSuchAuthorityCodeException e) {
                e.printStackTrace();
            }
            catch (FactoryException e) {
                e.printStackTrace();
            }
            typeBuilder.setCRS(coordinateReferenceSystem);
        }
        String namespace = "http://www.opengis.net/gml";
        typeBuilder.setNamespaceURI(namespace);
        NameImpl nameType = new NameImpl(namespace, "Feature");
        typeBuilder.setName((Name)nameType);
        typeBuilder.add("GEOMETRY", geometries.get(0).getClass());
        SimpleFeatureType featureType = typeBuilder.buildFeatureType();
        for (int i = 0; i < geometries.size(); ++i) {
            Feature feature = GTHelper.createFeature("" + i, geometries.get(i), featureType, new ArrayList<Property>());
            collection.add(feature);
        }
        return collection;
    }
}

